# Frontend API Interface Specification

---

## Overview
This document outlines the frontend API contract required to interact with the backend PHP application. All operations are triggered via a single endpoint (function.php) using POST or GET requests, with the action defined in the action field. Role-based access is enforced via session variables.

---

## Role Definitions

```sql
INSERT INTO `user_role` (`pk_role_id`, `role_name`, `scope`) VALUES
(1, "SystemAdmin", "Platform"),
(2, "SupportAgent", "Platform"),
(3, "ContentModerator", "Platform"),
(4, "BusinessOwner", "Tenant"),
(5, "BusinessManager", "Tenant"),
(6, "Staff", "Tenant"),
(7, "Operator", "Tenant"),
(8, "Customer", "Public");
```

## API Summary Table

| Action                            | Method | Required Role      | Payload Object           | Description                                                            |
|-----------------------------------|--------|--------------------|--------------------------|------------------------------------------------------------------------|
| `insertAddress`                   | POST   |  8   (logged in)   | `foodOrderAddress`       | For a logged in user to set up an addess                               |
| `insertUserToAddress`             | POST   |  8   (logged in)   | `foodOrderUserAddress`   | Linking an logged in user to an address                                |
| `insertOrder`                     | POST   |                    | `basket`                 | Create a new order                                                     |
| `viewAddress`                     | POST   |                    | `viewAddress`            | List of address                                                        |
| `checkOrderStatus`                | Get    | 8 or guestUserID   |                          | check Order Status                                                     |
| `viewOrder`                       | Get    |                    |                          | View Order by Id value                                                 |


## Payload Structures



### `insertAddress`
```json
{
    "action" : "insertAddress",
    "foodOrderAddress" : [ 
                "addressLine1"  : string,
                "addressLine2"  : string,
                "city"          : string,
                "county"        : string,
                "country"       : string,
                "postalCode"    : string,
            ],
}
```

### `insertUserToAddress`
```json
    "action" : "insertUserToAddress",
    "foodOrderUserAddress" : [ 
        "addressId"    : int,
        "isDefault"    : int, (1|0)
        "isActive"     : int
    ]
```

### `insertOrder`
```json
{
"action" : "insertOrder",
    "basket" : [
        "items" : [
            [
                "id" : int, 
                "quantity" : int, 
                "options" : [  // optional
                    [
                        "id" : int, // Extra Group ID
                        "extras" : [ // Extras for the option
                            [
                                ["id" : int,], // Extra ID
                                ["id" : int,],  // Another Extra ID
                                [...]
                            ]
                        ]
                    ],
                    [...]
                ]`
            ]
        ]
        "promotion" : [[],[]],
        "guestUser" : [ // Optional guest user data if not logged in
            "fName"         : string
            "lName"         : string,
            "phoneNumber"   : string,
            "userEmail"     : string,
            "address"       : [
                "addressLine1"  : string,
                "addressLine2"  : string,
                "city"          : string,
                "county"        : string,
                "country"       : string,
                "postalCode"    : string,
        ],
        "address"   : [
            "deliveryId" : int, // Assuming this is a valid address ID
        ],
        "deliveryType" : string "delivery", // Assuming this is a "delivery" or "collection"
        "comment" : string // Comments 
    ]
}
```

### `insertOrder`
```json
{
    "action" : "viewAddress",
}
```
    
### `checkOrderStatus`
```json
{
    "action"    : "checkOrderStatus",
    "orderId"   :  int,
    "guestId"   :  int, optional if not logged in  
}
```

### `viewOrder`
```json
{
    "action" : "viewOrder",
    "orderId": int,
    "email": string
}
```



```