<?php
    function menuTableColumnMapping($table = null, $roleId = null, $actionType = null) {
       $allMappings = [
            'food_order' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'userId'                => ['mapping' => 'user_id',                'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'guestUserId'           => ['mapping' => 'guest_user_id',          'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'tenantId'              => ['mapping' => 'tenant_id',              'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'deliveryAddressId'     => ['mapping' => 'delivery_address_id',    'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'billingAddressId'      => ['mapping' => 'billing_address_id',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'orderStatus'           => ['mapping' => 'order_status',           'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','completed','cancelled']],
                    'orderType'             => ['mapping' => 'order_type',             'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['delivery','pickup','dine-in']],
                    'paymentStatus'         => ['mapping' => 'payment_status',         'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['unpaid','paid','refunded','partial_refund']],
                    'currency'              => ['mapping' => 'currency',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'transactionId'         => ['mapping' => 'transaction_id',         'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'paymentIntentId'       => ['mapping' => 'payment_intent_id',      'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'comment'               => ['mapping' => 'comment',                'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'tenantComment'         => ['mapping' => 'tenant_comment',         'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'totalOrderPrice'       => ['mapping' => 'total_order_price',      'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedPrice' => ['mapping' => 'total_order_modified_price','updateRole' => [2, 4, 5], 'optionalInsert' => 1,'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedReason' => ['mapping' => 'total_order_modified_reason','updateRole' => [2, 4, 5], 'optionalInsert' => 1,'optionalUpdate' => 1, 'dataType' => 'string','expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_item', 'foreignKey' => 'orderId']],
            ],
            'food_order_item' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'orderId'               => ['mapping' => 'order_id',                'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuItemId'            => ['mapping' => 'menu_item_id',            'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'itemName'              => ['mapping' => 'item_name',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'string', 'expectedValue' => null],
                    'itemBasePrice'         => ['mapping' => 'item_base_price',         'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedPrice'     => ['mapping' => 'item_modified_price',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedReason'    => ['mapping' => 'item_modified_reason',    'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemQuantity'          => ['mapping' => 'item_quantity',           'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemNote'              => ['mapping' => 'item_note',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemStatus'            => ['mapping' => 'item_status',             'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','prepared','served','cancelled']],
                    'itemTenantComment'     => ['mapping' => 'item_tenant_comment',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_extra', 'foreignKey' => 'itemId']],
            ],
            'food_order_extra' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemId'                => ['mapping' => 'item_id',                 'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuExtraId'           => ['mapping' => 'menu_extra_id',           'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 1,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'extraName'             => ['mapping' => 'extra_name',              'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'extraPrice'            => ['mapping' => 'extra_price',             'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                ],
                'relationships' => [],
            ],
            'food_order_guest_user' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'fName'                 => ['mapping' => 'f_name',                  'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'lName'                 => ['mapping' => 'l_name',                  'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'phoneNumber'           => ['mapping' => 'phone_number',            'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'userEmail'             => ['mapping' => 'user_email',              'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order', 'foreignKey' => 'guestUserId']],
            ],
            'food_order_address' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'addressLine1'          => ['mapping' => 'address_line_1',          'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [0, 2, 4, 5],    'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'addressLine2'          => ['mapping' => 'address_line_2',          'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'city'                  => ['mapping' => 'city',                    'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'county'                => ['mapping' => 'county',                  'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'country'               => ['mapping' => 'country',                 'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'postalCode'            => ['mapping' => 'postal_code',             'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'checkSum'              => ['mapping' => 'check_sum',               'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [
                    ['table' => 'food_order', 'foreignKey' => 'deliveryAddressId'],
                    ['table' => 'food_order', 'foreignKey' => 'billingAddressId'],
                ],
            ],
            'food_order_user_address' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'userId'                => ['mapping' => 'user_id',                 'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'addressId'             => ['mapping' => 'address_id',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [0, 2, 4, 5],    'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'isDefault'             => ['mapping' => 'is_default',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'isActive'              => ['mapping' => 'is_active',               'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'isDeleted'             => ['mapping' => 'is_deleted',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                ],
                // No relationships for this table
                'relationships' => [],
            ],
        ];
        
        if (!$table) {
            return $allMappings;
        }
    
        $table = toSnakeCase($table);
        if (!isset($allMappings[$table])) {
            return null;
        }
    
        if ($roleId === null) {
            return $allMappings[$table];
        }
    
        $filtered = [];
        foreach ($allMappings[$table]['fields'] as $key => $meta) {
            if ($actionType === 'update' && isset($meta['updateRole'])) {
                if (in_array($roleId, $meta['updateRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'insert' && isset($meta['insertRole'])) {
                if (in_array($roleId, $meta['insertRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'view' && isset($meta['viewRole'])) {
                if (in_array($roleId, $meta['viewRole'])) {
                    $filtered[$key] = $meta;
                }
            }
        }

    
        return ['filtered' => $filtered, 'abc' => $table, 'roleId' => $roleId];
    }
    function findIdInData($data, $primaryKey) {
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                // Recurse into sub-arrays
                $found = findIdInData($value, $primaryKey);
                if ($found !== null) {
                    return $found;
                }
            } else {
                if ($key === $primaryKey) {
                    return $value;
                }
            }
        }
        return null;
    }
    function executeDatabaseOperation(&$inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function convertKeysToCamelCase($array) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Convert snake_case to camelCase
            $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
                return strtoupper($matches[1]);
            }, $key);

            // Lowercase first character to enforce camelCase
            $camelKey = lcfirst($camelKey);

            // Recursively handle nested arrays
            if (is_array($value)) {
                $converted[$camelKey] = convertKeysToCamelCase($value);
            } else {
                $converted[$camelKey] = $value;
            }
        }

        return $converted;
    }
    function toSnakeCase($input) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
    }
    function renameIdKeys($array, $newKeyName) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Recursively handle nested arrays
            if (is_array($value)) {
                $value = renameIdKeys($value, $newKeyName);
            }

            if ($key === 'id') {
                $converted[$newKeyName] = $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }
    function extractDataKeyFromTableName($tableName) {
        $parts = explode('_', $tableName, 2);
        $base = $parts[1] ?? $tableName;
    
        $baseParts = explode('_', $base);
    
        $camelCase = array_shift($baseParts);
    
        foreach ($baseParts as $part) {
            $camelCase .= ucfirst($part);
        }
    
        return $camelCase;
    }
    function roleViewType($roleId) {
        if(in_array($roleId, [1, 2, 3])) {
            return 'sysAdmin';
        } elseif($roleId == 4) {
            return 'owner';
        } elseif($roleId == 5) {
            return 'manager';
        } elseif($roleId == 6) {
            return 'staff';
        } else{
            return 'guest';
        }
    }
    function orderSetUP($inputData) {
        $inputData['basket']['step'][] = 'orderSetUP()';

        // set up transaction 
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        try {
            $pdo->beginTransaction();

            // ------------------ Basic validation ------------------
            if (empty($inputData['tenantId'])) {
                return rollbackTransaction($inputData, 'Tenant ID is required for order setup.');
            }

            $deliveryType = $inputData['basket']['deliveryType'] ?? null;
            $allowedDeliveryTypes = ['delivery', 'collection'];
            if (!in_array($deliveryType, $allowedDeliveryTypes, true)) {
                return rollbackTransaction($inputData, 'Delivery type must be delivery or collection.');
            }

            // Check opening status for selected delivery type
            $inputData['nextOperation'] = 'checkIfOpenForOrders';
            $res = executeDatabaseOperation($inputData);
            if ($res['status'] !== 'success') {
                return rollbackTransaction($inputData, $res['message']);
            }

            $hasUser  = !empty($inputData['userId']);
            $hasGuest = !empty($inputData['basket']['guestUser']);

            if (!$hasUser && !$hasGuest) {
                return rollbackTransaction($inputData, 'Either User Id or Guest Info is required for order setup.');
            }
            if ($hasUser && $hasGuest) {
                return rollbackTransaction($inputData, 'Both User Id and Guest Info cannot be set at the same time.');
            }

            $requiresAddress = ($deliveryType !== 'collection');
            $inputData['basket']['step'][] = 'orderSetUP() - validation complete';
            $inputData['basket']['step'][] = 'orderSetUP() - route selection';

            // ------------------ Registered user path ------------------
            if ($hasUser) {
                $inputData['basket']['step'][] = 'orderSetUP() - userId path';

                // Validate user
                $res = validateUser($inputData);
                if (($res['status'] ?? null) !== 'Found') {
                    return rollbackTransaction($inputData, 'User is invalid.');
                }

                if ($requiresAddress) {
                    $deliveryId = $inputData['basket']['address']['deliveryId'] ?? null;
                    if (empty($deliveryId)) {
                        return rollbackTransaction($inputData, 'Delivery Address Id is required for delivery orders when User Id is provided.');
                    }

                    $inputData['basket']['addressId'] = $deliveryId;
                    $res = validateAddress($inputData);
                    if (($res['status'] ?? null) !== 'Found') {
                        return rollbackTransaction($inputData, 'Delivery Address is invalid.');
                    }

                    $inputData['basket']['order']['deliveryAddressId'] = $deliveryId;
                }

                $inputData['basket']['order']['userId'] = $inputData['userId'];
            }

            // ------------------ Guest path ------------------
            if ($hasGuest) {
                $inputData['basket']['step'][] = 'orderSetUP() - guestUser path';

                if ($requiresAddress && (empty($inputData['basket']['guestUser']['address']))) {
                    return rollbackTransaction($inputData, 'Guest user address is required for delivery orders.');
                }

                // Insert guest user
                $inputData['nextOperation'] = 'insertData';
                $inputData['table'] = 'foodOrderGuestUser';
                $inputData['foodOrderGuestUser'] = $inputData['basket']['guestUser'];
                $res = executeDatabaseOperation($inputData);
                if (($res['status'] ?? null) !== 'success') {
                    return rollbackTransaction($inputData, 'Failed to insert guest user info.');
                }

                $guestId = $res['id'];
                $inputData['userId'] = $guestId; // reused internally
                $inputData['basket']['order']['guestUserId'] = $guestId;

                if ($requiresAddress) {
                    $inputData['foodOrderAddress'] = $inputData['basket']['guestUser']['address'];

                    // Generate checksum and check if exists
                    $inputData['foodOrderAddress']['checkSum'] = generateChecksum($inputData['foodOrderAddress']);
                    $inputData['nextOperation'] = 'checkAddressExists';
                    $res = executeDatabaseOperation($inputData);

                    if (($res['status'] ?? null) === 'Not Found') {
                        $inputData['nextOperation'] = 'insertData';
                        $inputData['table'] = 'foodOrderAddress';
                        $res = executeDatabaseOperation($inputData);
                        if (($res['status'] ?? null) !== 'success') {
                            return rollbackTransaction($inputData, 'Failed to insert guest user address.');
                        }
                        $addrId = $res['id'];
                    } else {
                        $addrId = $res['id'] ?? null;
                    }

                    if (empty($addrId)) {
                        return rollbackTransaction($inputData, 'Could not resolve delivery address id.');
                    }

                    $inputData['foodOrderAddress']['id'] = $addrId;
                    $inputData['basket']['order']['deliveryAddressId'] = $addrId;
                }
            }

            // ------------------ Resolve delivery vs collection ------------------
            if ($deliveryType === 'delivery') {
                $inputData['basket']['step'][] = 'orderSetUP() - delivery type: delivery';

                $inputData['addressId'] = $inputData['basket']['order']['deliveryAddressId'] ?? null;
                if (empty($inputData['addressId'])) {
                    return rollbackTransaction($inputData, 'Delivery address id missing after setup.');
                }

                $inputData['nextOperation'] = 'viewAddressById';
                $res = executeDatabaseOperation($inputData);
                if (($res['status'] ?? null) !== 'success') {
                    return rollbackTransaction($inputData, $res['message'] ?? 'Failed to load delivery address.');
                }
                $inputData['basket']['order']['deliveryAddress'] = $res['data'] ?? null;
            } else { // collection
                $inputData['basket']['step'][] = 'orderSetUP() - delivery type: collection';
                $inputData['nextOperation'] = 'shopAddress';
                $res = executeDatabaseOperation($inputData);
                if (($res['status'] ?? null) !== 'success') {
                    return rollbackTransaction($inputData, $res['message'] ?? 'Failed to load shop address.');
                }
            }

            $inputData['basket']['step'][] = 'orderSetUP() - setup complete';

            // ------------------ Items ------------------
            $res = validateItems($inputData);
            if (($res['status'] ?? null) !== 'success') {
                return rollbackTransaction($inputData, $res['message'] ?? 'Invalid items.');
            }

            // ------------------ Pricing + fees ------------------
            workOutPrices($inputData['basket']['order']);

            $inputData['basket']['step'][] = 'orderSetUP() - getting admin fee';
            $inputData['nextOperation'] = 'viewTenantFees';
            $res = executeDatabaseOperation($inputData);
            if (($res['status'] ?? null) !== 'success') {
                return rollbackTransaction($inputData, $res['message'] ?? 'Failed to load fees.');
            }

            $inputData['basket']['step'][] = 'orderSetUP() - getting minimum order amount and small order fee';
            $inputData['nextOperation'] = 'viewMinimumOrderAmount';
            $res = executeDatabaseOperation($inputData);
            if (($res['status'] ?? null) !== 'success') {
                return rollbackTransaction($inputData, $res['message'] ?? 'Failed to load minimum order amount.');
            }

            generateOrderCalculationDetails($inputData);

            // ------------------ Persist order ------------------
            $inputData['basket']['step'][] = 'orderSetUP() - inserting order into the database';
            $inputData['nextOperation'] = 'insertOrder';
            $res = executeDatabaseOperation($inputData);
            if (($res['status'] ?? null) !== 'success') {
                return rollbackTransaction($inputData, $res['message'] ?? 'Failed to insert order.');
            }

            $inputData['basket']['step'][] = 'orderSetUP() - inserting order items into the database';
            $inputData['nextOperation'] = 'insertOrderItems';
            $res = executeDatabaseOperation($inputData);
            if (($res['status'] ?? null) !== 'success') {
                return rollbackTransaction($inputData, $res['message'] ?? 'Failed to insert order items.');
            }

            // ------------------ Tenant API Key ------------------
            $inputData['basket']['step'][] = 'orderSetUP() - getting tenant API key';
            $inputData['nextOperation'] = 'viewTenantInfo';
            $res = executeDatabaseOperation($inputData);
            if (($res['status'] ?? null) !== 'success') {
                return rollbackTransaction($inputData, $res['message'] ?? 'Failed to load tenant info.');
            }

            // ------------------ Payment intent (non-test) ------------------
            if (!defined('TEST_ENV') || !TEST_ENV) {
                $inputData['basket']['step'][] = 'orderSetUP() - setting up payment intent';
                $res = setupStripeIntentDirect($inputData);
                if (($res['status'] ?? null) !== 'success') {
                    return rollbackTransaction($inputData, $res['message'] ?? 'Failed to set up payment intent.');
                }

                $inputData['basket']['step'][] = 'orderSetUP() - updating order with stripe intent id';
                $inputData['nextOperation'] = 'updateOrderWithPaymentIntent';
                $res = executeDatabaseOperation($inputData);
                if (($res['status'] ?? null) !== 'success') {
                    return rollbackTransaction($inputData, $res['message'] ?? 'Failed to update order with payment intent.');
                }
            }

            // ------------------ Response cleanup ------------------
            unset($inputData['basket']['order']['userId'], $inputData['basket']['order']['guestUserId']);
            unset($inputData['basket']['order']['deliveryAddressId'], $inputData['basket']['order']['minimumOrderAmount']);
            unset($inputData['basket']['order']['totalOrderModifiedReason'], $inputData['basket']['order']['orderComment']);

            $pdo->commit();

            return ['status' => 'success', 'message' => 'Order setup is complete.', 'basket' => $inputData['basket']['order']];

        } catch (Throwable $e) {
            if ($pdo->inTransaction()) {
                $pdo->rollBack();
            }
            return ['status' => 'error', 'message' => 'Order setup failed: '.$e->getMessage()];
        }
    }
    function generateChecksum(array $data): string{
        // Sort the array by key (alphabetically)
        ksort($data);

        // Normalize values (e.g., trim and cast to string)
        $normalizedValues = array_map(function ($value) {
            return is_null($value) ? '' : trim((string)$value);
        }, $data);

        // Join values with a consistent separator (e.g., pipe)
        $inputString = implode('|', $normalizedValues);

        // Generate checksum (SHA-256)
        return hash('sha256', $inputString);
    }
// return the updated inputData with the basket and order details in the array
    function validateItems(&$inputData) {
        $inputData['basket']['step'][] = 'validateItems() - start';
        if(!isset($inputData['basket']['items']) || empty($inputData['basket']['items'])) {
            return ['status' => 'failed', 'message' => 'Items are required for an order to be created.'];
        }
        // Loop through each item in the basket
        foreach ($inputData['basket']['items'] as $item) {
            // Validate id
            if (!isset($item['id']) || empty($item['id'])) {
                return ['status' => 'failed', 'message' => 'Each item must have a valid item id.'];
            }
            if (!(is_int($item['id']) || (is_string($item['id']) && ctype_digit($item['id'])))) {
                return ['status' => 'failed', 'message' => 'Each item id must be an integer.'];
            }

            // Validate quantity
            if (!isset($item['quantity'])) {
                return ['status' => 'failed', 'message' => 'Each item must have a quantity.'];
            }
            if (!(is_int($item['quantity']) || (is_string($item['quantity']) && ctype_digit($item['quantity'])))) {
                return ['status' => 'failed', 'message' => 'Each item quantity must be an integer.'];
            }
            if ((int)$item['quantity'] <= 0) {
                return ['status' => 'failed', 'message' => 'Each item must have a valid quantity greater than zero.'];
            }
            // get item info and check if the item exists in the database and for the correct tenant
            $inputData['basket']['step'][] = 'validateItems() - checking items in the database';
            $inputData['nextOperation'] = 'checkItemsExist';
            $inputData['currentItem'] = $item;
            $res = executeDatabaseOperation($inputData);
            if ($res['status'] !== 'Found') {
                return ['status' => 'failed', 'message' => 'Item with id ' . $item['id'] . ' does not exist or is not available for the current tenant.'];
            }
            // As part of the validation we need to check that the options are valid and available for the item and that the requiered options are selected based on min and max options
            // the option validation is in the $res['items']['options'] array

            $inboundOptions = normalizeInboundOptions($item['options'] ?? []);
            $dbOptionData = $res['items']['options'] ?? [];
            $optionValidationResult = ['status' => 'success', 'message' => 'No options required for item id ' . $item['id']];
            if (empty($dbOptionData) && empty($inboundOptions)) {
                $inputData['basket']['step'][] = 'validateItems() - no options required for item id ' . $item['id'];
            }else{
                // lets pass the inboundOptions and the DbOptionData to a function that will validate the options to keep the code clean
                $inputData['basket']['step'][] = 'validateItems() - validating options for item id ' . $item['id'];
            // Test up to here 
                $optionValidationResult = validateOptions($inboundOptions, $dbOptionData, $inputData);
                if ($optionValidationResult['status'] !== 'success') {
                    return ['status' => 'failed', 'message' => 'Options validation failed for item id ' . $item['id'] . ': ' . $optionValidationResult['message']]; // debug mode
                }
            }


            $inputData['basket']['order']['items'][] = [
                'menuItemId' => $item['id'],
                'itemName' => $res['items']['item_name'],
                'itemBasePrice' => $res['items']['base_price'],
                'itemQuantity' => $item['quantity'],
                'itemNote' => isset($item['note']) ? $item['note'] : '',
                'itemStatus' => 'pending', // Default status for new items'
                'options' => $optionValidationResult['options'] ?? []
            ];
            $inputData['basket']['order']['tenantId'] = $inputData['tenantId'];
            $inputData['basket']['order']['orderType'] = $inputData['basket']['deliveryType']; 
            $inputData['basket']['order']['orderComment'] = $inputData['basket']['comment'] ?? ''; 
        }

        $inputData['basket']['step'][] = 'validateItems() - validation complete';
        return ['status' => 'success', 'message' => 'Items are valid.'];
    }
    function validateOptions($inboundOptions, $dbOptionData, &$inputData) {
        $inputData['basket']['step'][] = 'validateOptions() - start';

        // Filter DB options to only those with a valid group ID
        $filteredDbOptions = array_filter($dbOptionData, function($group) {
            return !empty($group['optionGroupId']);
        });

        // Inbound options exist but DB options are empty ⇒ extras not allowed
        if (empty($filteredDbOptions) && !empty($inboundOptions)) {
            return [
                'status'  => 'failed',
                'message' => 'Item ' . ($inputData['currentItem']['id'] ?? '') .
                            ' does not allow extras, but extras were provided.'
            ];
        }
        
        // Step 1: Build list of valid group IDs
        $validOptionGroupIds = array_column($filteredDbOptions, 'optionGroupId');
        
        // Step 2: Fail if inbound has any unexpected group IDs
        foreach ($inboundOptions as $optionGroupId => $selectedOptions) {
            if (!in_array($optionGroupId, $validOptionGroupIds)) {
                return [
                    'status'  => 'failed',
                    'message' => 'Inbound option group with id ' . $optionGroupId .
                    ' does not exist in the database options.'
                ];
            }
        }
        
        // Step 3: Fail if any selected extra does not exist in the DB group
        foreach ($inboundOptions as $optionGroupId => $selectedOptions) {
            foreach ($selectedOptions as $extraId) {
                $extraId = (int) $extraId; // normalize inbound ID
                $found = false;
                foreach ($filteredDbOptions as $optionGroup) {
                    if ($optionGroup['optionGroupId'] == (int)$optionGroupId) { // normalize group ID too
                        $validExtraIds = array_map('intval', array_column($optionGroup['extra'], 'extraId'));
                        if (in_array($extraId, $validExtraIds, true)) {
                            $found = true;
                            break;
                        }
                    }
                }
                if (!$found) {
                    return [
                        'status'  => 'failed',
                        'message' => 'Inbound extra with id ' . $extraId .' for option group id ' . $optionGroupId .' does not exist in the extra options.'
                    ];
                }
            }
        }

        $inputData['basket']['step'][] = 'validateOptions() - no unexpected option groups in inbound options';

        // Step 4: Validate each group for required presence, duplicate selections, and min/max
        foreach ($filteredDbOptions as $optionGroup) {
            $optionGroupId = $optionGroup['optionGroupId'];
            $minSelect     = (int)$optionGroup['minSelect'];
            $maxSelect     = (int)$optionGroup['maxSelect'];

            // Missing required group
            if (!isset($inboundOptions[$optionGroupId])) {
                if ($minSelect >= 1) {
                    return [
                        'status'  => 'failed',
                        'message' => 'Required option group with id ' . $optionGroupId .
                                    ' is missing from the inbound options.'
                    ];
                }
                $inputData['basket']['step'][] = 'validateOptions() - optional group ' . $optionGroupId . ' not provided, skipping';
                continue;
            }

            $selectedOptions = (array)$inboundOptions[$optionGroupId];

            // ↪ Duplicate check
            if (count($selectedOptions) !== count(array_unique($selectedOptions))) {
                return [
                    'status'  => 'failed',
                    'message' => 'Duplicate extra with in option group ' . $optionGroupId . '.'
                ];
            }
            // ↪ Min/max check
            $selectedCount = count($selectedOptions);
            if ($selectedCount < $minSelect || $selectedCount > $maxSelect) {
                return [
                    'status'  => 'failed',
                    'message' => 'Selected options (' . $selectedCount . ') for option group ' .
                                $optionGroupId . ' do not meet min (' . $minSelect .
                                ') and max (' . $maxSelect . ') selection requirements.'
                ];
            }
        }

        // if we reach here, all options are valid
        $inputData['basket']['step'][] = 'validateOptions() - all option groups validated successfully';

        // build the options array for the order in a standalone array
        $options = [];
        // we will map the inbound options to the db options structure to get the extra names and prices
        foreach ($inboundOptions as $optionGroupId => $selectedExtras) {
            $options[$optionGroupId] = [];
            foreach ($selectedExtras as $extraId) {
                // find the extra in the db options
                foreach ($filteredDbOptions as $optionGroup) {
                    if ($optionGroup['optionGroupId'] == (int)$optionGroupId) {
                        foreach ($optionGroup['extra'] as $extra) {
                            if ($extra['extraId'] == (int)$extraId) {
                                $options[$optionGroupId][] = [
                                    'id' => $extra['extraId'],
                                    'name' => $extra['extraName'],
                                    'price' => $extra['priceAdjustment']
                                ];
                            }
                        }
                    }
                }
            }
        }

        $inputData['basket']['step'][] = 'validateOptions() - all options validated successfully';
        return ['status' => 'success', 'message' => 'All options are valid.', 'options' => $options];
    }
    function normalizeInboundOptions($rawInboundOptions) {
        $normalized = [];
        foreach ($rawInboundOptions as $item) {
            if (!isset($item['id'])) {
                continue; // skip invalid structure
            }

            $groupId = $item['id'];
            $selectedExtras = [];

            if (!empty($item['extras']) && is_array($item['extras'])) {
                foreach ($item['extras'] as $extraGroup) {
                    foreach ($extraGroup as $extra) {
                        if (isset($extra['id'])) {
                            $selectedExtras[] = $extra['id']; // ignore quantity for now
                        }
                    }
                }
            }

            if (!empty($selectedExtras)) {
                $normalized[$groupId] = $selectedExtras;
            }
        }
        return $normalized;
    }
    function rollbackTransaction($inputData, $message) {
        $inputData['basket']['step'][] = 'rollbackTransaction() - start';
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $pdo->rollBack();
        // get the last inserted step message
        $lastStep = end($inputData['basket']['step']);
        return ['status' => 'failed', 'message' => $message, 'lastStep' => $lastStep];
    }
    function workOutPrices(array &$order): void {
        $orderTotal = 0;

        foreach ($order['items'] as &$item) {
            $basePrice = (float)$item['itemBasePrice'];
            $itemTotal = $basePrice;

            $positiveExtras = [];
            $negativeExtras = [];

            // Sum extras for this item
            if (!empty($item['options']) && is_array($item['options'])) {
                foreach ($item['options'] as $optionGroup) {
                    foreach ($optionGroup as $extra) {
                        $price = isset($extra['price']) ? (float)$extra['price'] : 0.0;
                        $itemTotal += $price;

                        $name = $extra['name'] ?? 'Extra';
                        $formatted = number_format($price, 2);

                        if ($price >= 0) {
                            $positiveExtras[] = "$name (£$formatted)";
                        } else {
                            $negativeExtras[] = "$name (£$formatted)";
                        }
                    }
                }
            }

            // Multiply by quantity
            $itemTotal *= $item['itemQuantity'];
            $item['itemModifiedPrice'] = round($itemTotal, 2);

            // Build price note
            $itemModifiedReason = [];
            if (!empty($positiveExtras)) {
                $itemModifiedReason[] = 'Includes extras: ' . implode(', ', $positiveExtras);
            }
            if (!empty($negativeExtras)) {
                $itemModifiedReason[] = 'Includes discounts: ' . implode(', ', $negativeExtras);
            }

            $item['itemModifiedReason'] = $itemModifiedReason ? implode(' | ', $itemModifiedReason) : 'Base price only';

            // Add to order total
            $orderTotal += $item['itemModifiedPrice'];
        }

        $order['orderTotalPrice'] = round($orderTotal, 2);
    }
    function generateOrderCalculationDetails(&$inputData){
        $inputData['basket']['order']['totalOrderModifiedReason'] = '';

        $inputData['step'][] = 'orderSetUP() - checking total order price against minimum order amount';

        if($inputData['basket']['order']['orderTotalPrice'] < $inputData['basket']['order']['minimumOrderAmount']) {
           // if less add the small order fee to the total order price
            $inputData['basket']['order']['totalOrderModifiedPrice'] = $inputData['basket']['order']['orderTotalPrice'];
            $inputData['basket']['order']['totalOrderModifiedPrice'] += $inputData['basket']['order']['smallOrderFee'];
            $inputData['basket']['order']['totalOrderModifiedReason'] = 'Small Order Fee Applied, ';
        }else{
             $inputData['basket']['order']['totalOrderModifiedPrice'] = $inputData['basket']['order']['orderTotalPrice'];
        }

        $inputData['basket']['step'][] = 'orderSetUP() - total order price checked against minimum order amount';

        // Delivery Charges

        if($inputData['basket']['deliveryType'] === 'delivery') {
            $inputData['basket']['step'][] = 'orderSetUP() - delivery type is delivery';
            $inputData['nextOperation'] = 'viewTenantDeliveryRulesBasedOrder';
            $res = executeDatabaseOperation($inputData);
            if($res['status'] !== 'success') {
               return rollbackTransaction($inputData, $res['message']);
            }
        }

        // check the delivery charge and add it to the total order price
        if(isset($inputData['basket']['order']['deliveryCharges']) && $inputData['basket']['order']['deliveryCharges'] > 0) {
            $inputData['basket']['order']['totalOrderModifiedPrice'] += $inputData['basket']['order']['deliveryCharges'];
            $inputData['basket']['order']['totalOrderModifiedReason'] .= 'Delivery Charge Applied, ';
        }

        $inputData['basket']['step'][] = 'orderSetUP() - delivery charges checked and added to total order price';

        // add the admin fee to the total order price
        if(isset($inputData['basket']['order']['customerAdminFee']) && $inputData['basket']['order']['customerAdminFee'] > 0) {
            $inputData['basket']['order']['totalOrderModifiedPrice'] += $inputData['basket']['order']['customerAdminFee'];
            $inputData['basket']['order']['totalOrderModifiedReason'] .= 'Admin Fee Applied, ';
        }

        // remove the last comma and space from the totalOrderModifiedReason
        if(!empty($inputData['basket']['order']['totalOrderModifiedReason'])) {
            $inputData['basket']['order']['totalOrderModifiedReason'] = rtrim($inputData['basket']['order']['totalOrderModifiedReason'], ', ');
        } else {
            $inputData['basket']['order']['totalOrderModifiedReason'] = 'No modifications applied';
        }
        $inputData['basket']['step'][] = 'orderSetUP() - admin fee checked and added to total order price';
        return;
    }
    function countryToShortCode(string $country): ?string {
        $map = [
            'United Kingdom' => 'UK',
            'United States' => 'US',
            'Canada' => 'CA',
            'Australia' => 'AU',
            'Germany' => 'DE',
            'France' => 'FR',
            'Italy' => 'IT',
            'Spain' => 'ES',
            'Netherlands' => 'NL',
            'India' => 'IN',
            'China' => 'CN',
            'Japan' => 'JP',
            'Brazil' => 'BR',
            'Mexico' => 'MX',
            'South Africa' => 'ZA',
            // Add more as needed
        ];

        $country = trim($country);

        return $map[$country] ?? $country;
    }
    function smartUcwords($value) {
        return preg_replace_callback('/\b\w+\b/u', function ($matches) {
            $word = $matches[0];
            return ctype_alpha($word[0])
                ? ucfirst(strtolower($word))
                : $word; // leave unchanged if it starts with a digit
        }, $value);
    }
// Stripe Functions
    function stripeInboundDecision(array &$inputData) {
        // The Stripe event you proxied in under 'data'
        $event = $inputData['data'] ?? null;
        if (!$event || !is_array($event)) {
            return ['status' => 'failed', 'message' => 'Missing Stripe event'];
        }

        $type = $event['type'] ?? '';
        $obj  = $event['data']['object'] ?? [];
        if (!$type || !$obj) {
            return ['status' => 'failed', 'message' => 'Malformed Stripe event'];
        }

        // Helpers to extract order ID / PI ID regardless of object type
        $paymentIntentId = $obj['id'] ?? null;
        if (($obj['object'] ?? '') === 'charge') {
            $paymentIntentId = $obj['payment_intent'] ?? null;
        }
        $meta = $obj['metadata'] ?? [];
        // Also try to get metadata from the latest charge if present (for PI events)
        if (($obj['object'] ?? '') === 'payment_intent') {
            if (empty($meta) && !empty($obj['charges']['data'][0]['metadata'])) {
                $meta = $obj['charges']['data'][0]['metadata'];
            }
        }
        $orderId  = $meta['orderId']  ?? null;
        $tenantId = $meta['tenantId'] ?? null;

        // inputData setup

        $inputData['secure']['paymentIntentId'] = $paymentIntentId;
        $inputData['secure']['orderId']         = $orderId;
        $inputData['secure']['tenantId']        = $tenantId;

        switch ($type) {
            case 'payment_intent.amount_capturable_updated':
                // Official “pre-auth ready” signal
                $status            = $obj['status'] ?? '';
                $amountCapturable  = (int)($obj['amount_capturable'] ?? 0);
                if ($status === 'requires_capture' && $amountCapturable > 0) {
                    // 🔔 Trigger your internal “ask restaurant” step
                    // example: queue task / send notification
                    askRestaurantToAccept($inputData);

                    return [
                        'status'   => 'success',
                        'message'  => 'Pre-auth ready; restaurant notified',
                    ];
                }
                return ['status' => 'ignored', 'message' => 'Not capturable yet', 'event' => $type];

            case 'payment_intent.succeeded':
                // 💰 Funds captured
                //markOrderPaid($paymentIntentId, $orderId, $tenantId);
                return ['status' => 'success', 'message' => 'Payment captured', 'event' => $type, 'orderId' => $orderId];

            case 'payment_intent.canceled':
                // ❌ Hold released
                //markOrderCancelled($paymentIntentId, $orderId, $tenantId);
                return ['status' => 'success', 'message' => 'Pre-auth canceled', 'event' => $type, 'orderId' => $orderId];

            case 'payment_intent.payment_failed':
                //markOrderFailed($paymentIntentId, $orderId, $tenantId);
                return ['status' => 'success', 'message' => 'Payment failed', 'event' => $type, 'orderId' => $orderId];

            case 'charge.succeeded':
                // Fires on both auth AND capture; detect auth-only
                $captured        = $obj['captured'] ?? false;              // bool
                $amountCaptured  = (int)($obj['amount_captured'] ?? 0);
                if ($captured === false && $amountCaptured === 0) {
                    // Just an authorization (pre-auth hold). Optional: log/audit only.
                    //logAuthHold($obj['id'] ?? null, $paymentIntentId, $orderId, $tenantId);
                    return ['status' => 'ignored', 'message' => 'Auth hold placed', 'event' => $type, 'orderId' => $orderId];
                }
                // Else it’s a captured charge (you’ll also see payment_intent.succeeded)
                return ['status' => 'ignored', 'message' => 'Captured charge handled elsewhere', 'event' => $type];

            case 'charge.refunded':
                //markOrderRefunded($obj['id'] ?? null, $orderId, $tenantId);
                return ['status' => 'success', 'message' => 'Refund processed', 'event' => $type, 'orderId' => $orderId];

            case 'payment_intent.created':
                // No business action needed; good for logging
                return ['status' => 'ignored', 'message' => 'PI created', 'event' => $type, 'orderId' => $orderId];

            default:
                return ['status' => 'ignored', 'message' => 'Unhandled event', 'event' => $type];
        }
    }
?>