<?php

    function menuTableColumnMapping($table = null, $roleId = null) {
       $allMappings = [
            'food_order_order' => [
                'fields' => [
                    'id'                   => ['mapping' => 'id',                     'updateRole' => [2, 4, 5], 'optionalInsert' => null, 'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'userId'              => ['mapping' => 'user_id',                'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'guestUserId'         => ['mapping' => 'guest_user_id',          'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'tenantId'            => ['mapping' => 'tenant_id',              'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'deliveryAddressId'   => ['mapping' => 'delivery_address_id',    'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'billingAddressId'    => ['mapping' => 'billing_address_id',     'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'orderStatus'         => ['mapping' => 'order_status',           'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','completed','cancelled']],
                    'orderType'           => ['mapping' => 'order_type',             'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['delivery','pickup','dine-in']],
                    'paymentStatus'       => ['mapping' => 'payment_status',         'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['unpaid','paid','refunded','partial_refund']],
                    'currency'            => ['mapping' => 'currency',               'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'transactionId'       => ['mapping' => 'transaction_id',         'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'comment'             => ['mapping' => 'comment',                'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'tenantComment'       => ['mapping' => 'tenant_comment',         'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'totalOrderPrice'     => ['mapping' => 'total_order_price',      'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedPrice' => ['mapping' => 'total_order_modified_price','updateRole' => [2, 4, 5], 'optionalInsert' => 1,'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedReason' => ['mapping' => 'total_order_modified_reason','updateRole' => [2, 4, 5], 'optionalInsert' => 1,'optionalUpdate' => 1, 'dataType' => 'string','expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_item', 'foreignKey' => 'orderId']],
            ],
            'food_order_item' => [
                'fields' => [
                    'id'               => ['mapping' => 'id',                    'updateRole' => [2, 4, 5], 'optionalInsert' => null, 'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'orderId'          => ['mapping' => 'order_id',              'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuItemId'       => ['mapping' => 'menu_item_id',          'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'itemName'         => ['mapping' => 'item_name',             'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'string', 'expectedValue' => null],
                    'itemBasePrice'    => ['mapping' => 'item_base_price',       'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedPrice'=> ['mapping' => 'item_modified_price',   'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedReason'=>['mapping' => 'item_modified_reason',  'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemQuantity'     => ['mapping' => 'item_quantity',         'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemNote'         => ['mapping' => 'item_note',             'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemStatus'       => ['mapping' => 'item_status',           'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','prepared','served','cancelled']],
                    'itemTenantComment'=> ['mapping' => 'item_tenant_comment',   'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_extra', 'foreignKey' => 'itemId']],
            ],
            'food_order_extra' => [
                'fields' => [
                    'id'           => ['mapping' => 'id',               'updateRole' => [2, 4, 5], 'optionalInsert' => null, 'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemId'       => ['mapping' => 'item_id',          'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuExtraId'  => ['mapping' => 'menu_extra_id',    'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'extraName'    => ['mapping' => 'extra_name',       'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'extraPrice'   => ['mapping' => 'extra_price',      'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                ],
                'relationships' => [],
            ],
            'food_order_guest_user' => [
                'fields' => [
                    'id'         => ['mapping' => 'id',           'updateRole' => [2, 4, 5], 'optionalInsert' => null, 'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'fName'      => ['mapping' => 'f_name',       'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'lName'      => ['mapping' => 'l_name',       'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'phoneNumber'=> ['mapping' => 'phone_number', 'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'userEmail'  => ['mapping' => 'user_email',   'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_order', 'foreignKey' => 'guestUserId']],
            ],
            'food_order_address' => [
                'fields' => [
                    'id'            => ['mapping' => 'id',               'updateRole' => [2, 4, 5], 'optionalInsert' => null, 'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'addressLine1'  => ['mapping' => 'address_line_1',   'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'addressLine2'  => ['mapping' => 'address_line_2',   'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'city'          => ['mapping' => 'city',             'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'state'         => ['mapping' => 'state',            'updateRole' => [2, 4, 5], 'optionalInsert' => 1,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'country'       => ['mapping' => 'country',          'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'postalCode'    => ['mapping' => 'postal_code',      'updateRole' => [2, 4, 5], 'optionalInsert' => 0,    'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [
                    ['table' => 'food_order_order', 'foreignKey' => 'deliveryAddressId'],
                    ['table' => 'food_order_order', 'foreignKey' => 'billingAddressId'],
                ],
            ],
        ];

        
        if (!$table) {
            return $allMappings;
        }
    
        $table = toSnakeCase($table);
        if (!isset($allMappings[$table])) {
            return null;
        }
    
        if ($roleId === null) {
            return $allMappings[$table];
        }
    
        $filtered = [];
        //foreach ($allMappings[$table] as $key => $meta) {
        foreach ($allMappings[$table]['fields'] as $key => $meta) {
            if (in_array($roleId, $meta['updateRole'])) {
                $filtered[$key] = $meta;
            }
        }
    
        return ['filtered' => $filtered];
    }

    function findIdInData($data, $primaryKey) {
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                // Recurse into sub-arrays
                $found = findIdInData($value, $primaryKey);
                if ($found !== null) {
                    return $found;
                }
            } else {
                if ($key === $primaryKey) {
                    return $value;
                }
            }
        }
        return null;
    }
    function executeDatabaseOperation( $inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function convertKeysToCamelCase($array) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Convert snake_case to camelCase
            $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
                return strtoupper($matches[1]);
            }, $key);

            // Lowercase first character to enforce camelCase
            $camelKey = lcfirst($camelKey);

            // Recursively handle nested arrays
            if (is_array($value)) {
                $converted[$camelKey] = convertKeysToCamelCase($value);
            } else {
                $converted[$camelKey] = $value;
            }
        }

        return $converted;
    }
    function toSnakeCase($input) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
    }
    function renameIdKeys($array, $newKeyName) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Recursively handle nested arrays
            if (is_array($value)) {
                $value = renameIdKeys($value, $newKeyName);
            }

            if ($key === 'id') {
                $converted[$newKeyName] = $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }
    function extractDataKeyFromTableName($tableName) {
        $parts = explode('_', $tableName, 2);
        $base = $parts[1] ?? $tableName;
    
        $baseParts = explode('_', $base);
    
        $camelCase = array_shift($baseParts);
    
        foreach ($baseParts as $part) {
            $camelCase .= ucfirst($part);
        }
    
        return $camelCase;
    }
    function roleViewType($roleId) {
        if(in_array($roleId, [1, 2, 3])) {
            return 'sysAdmin';
        } elseif($roleId == 4) {
            return 'owner';
        } elseif($roleId == 5) {
            return 'manager';
        } elseif($roleId == 6) {
            return 'staff';
        } else{
            return 'guest';
        }
    }
    function orderSetUP($inputData){
        if(!isset($inputData['tenantId'])) {
            return ['status' => 'failed', 'message' => 'Tenant ID is required for order setup.'];
        }
        if (!isset($inputData['userId']) || (!isset($inputData['basket']['guestUser']) )){ //&& !empty($inputData['basket']['guestUser']))) {
            return ['status' => 'failed', 'message' => 'Either User Id or Guest Info is required for order setup.'];
        }

        return ['status' => 'success'];
    }
?>