<?php
    // this should only be used for testing purposes
    if (defined('TEST_ENV')) {
        //require_once __DIR__ . '/../../orbit-core/src/config.php';
        require_once __DIR__ . '\..\..\core\src\Fcors.php';
        require_once __DIR__ . '\..\..\tests\scripts\bootstrap.php';
        require_once __DIR__ . '\..\..\core\src\generic.php';
        $testInfo['0'] = ("\nFunction Running in Test Environment\n");
    } else {
        // this is code for live environment Dev, Uat, Production
        require_once __DIR__ . "./../error_monitor.php";
        require_once __DIR__ . "./../generic.php";
    }

    require_once __DIR__ . "/core.php";
    require_once __DIR__ . "/view.php";
    require_once __DIR__ . "/insert.php";
    require_once __DIR__ . "/update.php";

    $inputData = initializeGeneric();

    $inputData['requiresAdmin'] = [ 'Temp1'           =>  [2,4,5]];
    $inputData['keepLive'] = checkLive();
    $action = $inputData['action'];

    // check if action need auth and if does check it valid otherwise move to swithc statments 
    $security = SecurityCheck($inputData); // skip security for a bit 

    if(isset($inputData['tenantId']) == false || $inputData['tenantId'] == null ){
        setTenantId($inputData);
        reinitializeTenantId($inputData);
    }
    if($security['security'] === '1'){
        switch ($action) {
            //Test
                case "test":
                    $out['status']   = 'success';
                    $out['message']  = 'Test Passed';
                    break;
            // View
                case "viewAddress":
                    $inputData['table']         = 'foodOrderAddress';
                    $inputData['nextOperation'] = 'viewAddressWithUserLink';
                    $out = executeDatabaseOperation($inputData);
                    break;
                case "checkOrderStatus":
                    $inputData['nextOperation'] = 'checkOrderStatus';
                    $out = executeDatabaseOperation($inputData);
                    break;
                // insert
                case "insertAddress":
                    if (!isset($inputData['foodOrderAddress']['checkSum']) || empty($inputData['foodOrderAddress']['checkSum'])) {
                        $inputData['foodOrderAddress']['checkSum'] = generateCheckSum($inputData['foodOrderAddress']);
                    }
                    // check if address already exists
                    $inputData['nextOperation'] = 'checkAddressExists';
                    $out = executeDatabaseOperation($inputData);
                    if ($out['status'] === 'Found') {
                        // If address already exists, return the error
                        $out = [
                            'status' => 'failed',
                            'message' => 'Address already exists'
                        ];
                        break;
                    }
                    $inputData['table']         = 'foodOrderAddress';
                    $inputData['nextOperation'] = 'insertData';
                    $out = executeDatabaseOperation($inputData);
                    break;
                case "insertUserToAddress":
                    $inputData['table']         = 'foodOrderUserAddress';
                    if (!empty($inputData['userId'])) {
                        $inputData['foodOrderUserAddress']['userId'] = $inputData['userId'];
                    }
                    $inputData['nextOperation'] = 'insertData';
                    $out = executeDatabaseOperation($inputData);
                    break;
                case "insertOrder":
                    $inputData['nextOperation'] = 'orderSetUP';
                    $out = executeDatabaseOperation($inputData);
                    break;
            // Stipe
                case "stripeInbound":
                    $out  = stripeInboundDecision($inputData);
                    break;
            // Extras
            default:
                $out['status']   = 'failed';
                $out['message']  = 'No Action Found';
                break;
        }
    }else{
        $out = $security;
        if($security['security'] === '0'){
            unset($out['security']);
        }

    }

    if(defined('TEST_ENV')){
    //    $out['testInfo']['1'] = $testInfo;
    //    $out['testInfo']['2'] = $_GET;
    //    $out['testInfo']['3'] = $_POST;
    //    $out['inputData']     = $inputData;
        $out['security']      = $security;
        $out['action']        = $action;
    }
    cleanUpOutputData($out);
    echo json_encode(propagateStatusAndMessage($out));
?>
