
# ✅ Orbit Menu Module — Test Plan

This document outlines a detailed test plan for validating the functionality, integrity, and user experience of the `orbit-menu` module.

---

## 🔍 Test Areas

### 1. Menu Management (Admin + Owner)
| Test Case | Description | Role | Expected Outcome |
|-----------|-------------|------|------------------|
| TC1 | Create a new menu for a tenant | Admin | Menu is created, appears in DB |
| TC2 | Set menu as active | Admin | Only one menu per tenant is active |
| TC3 | Duplicate a menu | Admin | New menu with same structure created |
| TC4 | Owner can create category | Owner | Category appears under correct menu |
| TC5 | Owner can add items to categories | Owner | Items saved and visible in menu tree |

---

### 2. Item Customization & Enrichment
| Test Case | Description | Role | Expected Outcome |
|-----------|-------------|------|------------------|
| TC6 | Add a variant to an item | Owner | Variant appears on item detail |
| TC7 | Assign allergens to item | Owner | Allergens visible in item view |
| TC8 | Define nutritional info | Owner | Nutritional data saved properly |
| TC9 | Set item availability (time & days) | Owner | Item only appears during configured time |

---

### 3. Meal Management
| Test Case | Description | Role | Expected Outcome |
|-----------|-------------|------|------------------|
| TC10 | Create fixed meal | Owner | Meal shown with static items |
| TC11 | Add options group to a meal | Owner | Group visible in meal config |
| TC12 | Assign selectable items to group | Owner | Items selectable in frontend builder |
| TC13 | Apply pricing adjustments on options | Owner | Total meal price is calculated correctly |

---

### 4. Public Menu Rendering
| Test Case | Description | Role | Expected Outcome |
|-----------|-------------|------|------------------|
| TC14 | Fetch public menu structure | Public | Only active, available items are shown |
| TC15 | Items filtered by time/day | Public | Hidden outside availability |
| TC16 | Localization applied (en, fr, etc) | Public | Items show correct language |
| TC17 | Visibility and context filtering | Public | Only correct items shown per role/context |

---

### 5. Data Integrity
| Test Case | Description | Expected Outcome |
|-----------|-------------|------------------|
| TC18 | Foreign key constraints respected | No orphaned data |
| TC19 | Menu duplicates maintain references | Copied IDs do not overwrite originals |
| TC20 | Variants linked to correct item | Data integrity maintained |
| TC21 | Meals and options correctly link items | Meal structure remains valid |

---

### 6. Access Control
| Test Case | Description | Expected Outcome |
|-----------|-------------|------------------|
| TC22 | Admin can access all tenants' menus | Full cross-tenant control |
| TC23 | Owner sees only their menus/items | Scoped to tenant ID |
| TC24 | Public sees only public-facing data | Role and visibility respected |

---

### 7. Error Handling & Validation
| Test Case | Description | Expected Outcome |
|-----------|-------------|------------------|
| TC25 | Fail to create item without category | Graceful error message |
| TC26 | Add too many options to a group | Validation error shown |
| TC27 | Assign invalid allergen ID | Foreign key violation prevented |
| TC28 | Invalid price formats rejected | Validation blocks incorrect data |

---

## ✅ Test Checklist

| Test Case ID | Status (✔/✘) |
|--------------|--------------|
| TC1          | ✘            |
| TC2          | ✘            |
| TC3          | ✘            |
| TC4          | ✘            |
| TC5          | ✘            |
| TC6          | ✘            |
| TC7          | ✘            |
| TC8          | ✘            |
| TC9          | ✘            |
| TC10         | ✘            |
| TC11         | ✘            |
| TC12         | ✘            |
| TC13         | ✘            |
| TC14         | ✘            |
| TC15         | ✘            |
| TC16         | ✘            |
| TC17         | ✘            |
| TC18         | ✘            |
| TC19         | ✘            |
| TC20         | ✘            |
| TC21         | ✘            |
| TC22         | ✘            |
| TC23         | ✘            |
| TC24         | ✘            |
| TC25         | ✘            |
| TC26         | ✘            |
| TC27         | ✘            |
| TC28         | ✘            |
