<?php
    ini_set('error_log', 'php://stderr');
    error_log("Something went wrong");
    use PHPUnit\Framework\TestCase;
    //require_once __DIR__ . '/../../tests/scripts/bootstrap.php'; // ✅ Use shared mock DB
    //require_once __DIR__ . '/../src/function.php';
    echo "\n>>>>>>>>>>>>>>>>>>>>>>>>>====<<<<<<<<<<<<<<<<<<<<<<<<<\n";
    echo "\T07_MenuTest.php\n"; 
    // Print list of table that exist in the database
    //$tables = $GLOBALS['mockPdo']->query("SELECT name FROM sqlite_master WHERE type='table';")->fetchAll(PDO::FETCH_COLUMN);
    //echo("\n🔍 Tables: " . implode(', ', $tables). "\n");
    class T07_MenuTest extends TestCase
    {
            private $mockPdo;
            private static $lastModified;

        protected function setUp(): void{
            // ✅ Use the shared mock database connection
            $_SESSION = [];
            $_GET = [];
            $_POST = [];
            $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
            $_SERVER['HTTP_REFERER'] = 'http://localhost/test';
            $this->mockPdo = $GLOBALS['mockPdo'];
            if (session_status() !== PHP_SESSION_ACTIVE) {
                session_start();
            }
        }
        private function executeFunctionPhp(): array {
            ob_start();
            // Flexible path resolution for module function.php
            if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php')) {
                require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php';
            } else {
                require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'function.php';
            }
            $output = ob_get_clean();
        
            // ✅ Ensure only valid JSON output
            $decodedOutput = json_decode($output, true);
            if (json_last_error() !== JSON_ERROR_NONE) {
                throw new Exception("Invalid JSON output: " . json_last_error_msg() . "\nOutput: " . $output);
            }
        
            return [$output, $decodedOutput];
        }
        public function test001DummyTest(): void{
            $this->assertTrue(true);
        }
        // Menu Top Level Tests
        public function test002InsertIntoMenuMenusSysAdmin(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertIntoMenuMenus',
                'menuMenus' => [
                    'name' => 'Test Menu 1',
                    'description' => 'Test Description',
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
            // Check if the record was inserted correctly
            $stmt = $this->mockPdo->query("SELECT * FROM menu_menus WHERE menu_name = 'Test Menu 1'");
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertEmpty($result, "Record should not be found in the database.");
            
        }
        public function test003InsertIntoMenuMenusOwner(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertIntoMenuMenus',
                'menuMenus' => [
                    'name' => 'Test Menu',
                    'description' => 'Test Description',
                    'isActive' => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
            // Check if the record was inserted correctly
            $stmt = $this->mockPdo->prepare("SELECT * FROM menu_menus WHERE menu_name = 'Test Menu' and id = 2");
            $stmt->execute();
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            //echo print_r($result, true); // Debug output
            $this->assertNotEmpty($result, "Record not found in the database.");
            $this->assertEquals('Test Menu', $result['menu_name']);
            $this->assertEquals('Test Description', $result['menu_description']);
            $this->assertEquals(1, $result['is_active']);
            $this->assertEquals(0, $result['is_deleted']);
        }
        public function test004UpdateMenuMenusSysAdmin(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuMenus',
                'menuMenus' => [
                    'id' => 1,
                    'name' => 'Updated Menu',
                    'description' => 'Updated Description',
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test005UpdateMenuMenusOwnerSetActive(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuMenus',
                'menus' => [
                    'id' => 2,
                    'isActive' => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Update completed successfully', $decodedOutput['message']);

            $stmt = $this->mockPdo->query("SELECT * FROM menu_menus WHERE id = 2");
            $rows = $stmt->fetch(PDO::FETCH_ASSOC);
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals(1, $rows['is_active']);
        }
        public function test006UpdateMenuMenusOwnerInverseSetActive(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuMenus',
                'menus' => [
                    'id' => 2,
                    'isActive' => 0
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Update completed successfully', $decodedOutput['message']);

            $stmt = $this->mockPdo->query("SELECT * FROM menu_menus WHERE id = 2");
            $rows = $stmt->fetch(PDO::FETCH_ASSOC);
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals(0, $rows['is_active']);
        }
        public function test007UpdateMenuMenusOwner(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuMenus',
                'menus' => [
                    'id' => 2,
                    'name' => 'Updated Menu',
                    'description' => 'Updated Description',
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Update completed successfully', $decodedOutput['message']);

            // check history record
            $stmt = $this->mockPdo->query("SELECT * FROM menu_audit_log  WHERE action_type = 'update' AND table_of_source = 'menu_menus' AND action_by = 293");
            $rows = $stmt->fetch(PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals(1, $rows['id']);

            $stmt = $this->mockPdo->query("SELECT * FROM menu_menus WHERE id = 2");
            $rows = $stmt->fetch(PDO::FETCH_ASSOC);
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals('Updated Menu', $rows['menu_name']);
            $this->assertEquals('Updated Description', $rows['menu_description']);
        }
        public function test008UpdateMenuMenusOwnerWithNoId(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuMenus',
                'menus' => [
                    'name' => 'Updated Menu',
                    'description' => 'Updated Description',
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Missing required Id field: id key: menu_menus', $decodedOutput['message']);
        }
        public function test009UpdateMenuMenusPublic(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 0;         // Role Value (0 = Public)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuMenus',
                'menus' => [
                    'id' => 1,
                    'name' => 'Updated Menu',
                    'description' => 'Updated Description',
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test010UpdateMenuMenusOwnerAlreadyDeleted(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuMenus',
                'menus' => [
                    'id' => 1,
                    'name' => 'Updated Menu',
                    'description' => 'Updated Description',
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Record already deleted', $decodedOutput['message']);
        }
        public function test011DeleteMenuMenusSysAdmin(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'deleteMenuMenus',
                'menuMenus' => [
                    'id' => 1
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test012DeleteMenuMenusOwnerAlreadyDeleted(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'deleteMenuMenus',
                'menus' => [
                    'id' => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Record already deleted', $decodedOutput['message']);
        }
        public function test013DeleteMenuMenusOwnerWithNoId(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'deleteMenuMenus',
                'menus' => []
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Missing required Id field: id key: menu_menus', $decodedOutput['message']);
        }
        public function test014DeleteMenuMenusPublic(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 0;         // Role Value (0 = Public)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'deleteMenuMenus',
                'menus' => [
                    'id' => 1
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test015DeleteMenuMenusOwner(): void {
            $_SESSION['id'] = 295;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'deleteMenuMenus',
                'menus' => [
                    'id' => 2
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Update completed successfully', $decodedOutput['message']);

            // check history record
            $stmt = $this->mockPdo->query("SELECT * FROM menu_audit_log WHERE action_type = 'delete' AND table_of_source = 'menu_menus' AND action_by = 295");
            $rows = $stmt->fetch(PDO::FETCH_ASSOC);      
            // Debug output
            //echo print_r($rows, true); // or var_dump($rows)
            //print_r($rows['id']); // or var_dump($rows)
            $this->assertEquals(8, $rows['id']);

            $stmt = $this->mockPdo->query("SELECT * FROM menu_menus WHERE id = 2");
            $rows = $stmt->fetch(PDO::FETCH_ASSOC);
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals(1, $rows['is_deleted']);
        }
        public function test016InsertTwoNewThemes(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertIntoMenuMenus',
                'menuMenus' => [
                    'name' => 'Test Menu 2',
                    'description' => 'Test Description 2'
                ]
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Record inserted successfully', $decodedOutput['message']);

            $_POST = [
                'action' => 'insertIntoMenuMenus',
                'menuMenus' => [
                    'name' => 'Test Menu 2',
                    'description' => 'Test Description 2',
                    'isActive' => 1,
                    'themeStatus' => 'active'
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
        }
        public function test017ViewMenuMenusSysAdmin(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'viewMenuMenus',
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            $expectedResult = [
                'status' => 'success',
                'menuMenus' => [
                    [
                        'menuId' => 4,
                        'tenantId' => 1,
                        'menuName' => 'Test Menu 2',
                        'menuDescription' => 'Test Description 2',
                        'isActive' => 1,
                        'isDeleted' => 0,
                        'createdAt' => $decodedOutput['menuMenus'][0]['createdAt'],
                        'updatedAt' => $decodedOutput['menuMenus'][0]['updatedAt'],
                    ],
                    [
                        'menuId' => 3,
                        'tenantId' => 1,
                        'menuName' => 'Test Menu 2',
                        'menuDescription' => 'Test Description 2',
                        'isActive' => 0,
                        'isDeleted' => 0,
                        'createdAt' => $decodedOutput['menuMenus'][1]['createdAt'],
                        'updatedAt' => $decodedOutput['menuMenus'][1]['updatedAt'],
                    ],
                    [
                        'menuId' => 2,
                        'tenantId' => 1,
                        'menuName' => 'Updated Menu',
                        'menuDescription' => 'Updated Description',
                        'isActive' => 0,
                        'isDeleted' => 1,
                        'createdAt' => $decodedOutput['menuMenus'][2]['createdAt'],
                        'updatedAt' => $decodedOutput['menuMenus'][2]['updatedAt'],
                    ],
                    [
                        'menuId' => 1,
                        'tenantId' => 1,
                        'menuName' => 'Test Menu',
                        'menuDescription' => 'Test Description',
                        'isActive' => 0,
                        'isDeleted' => 1,
                        'createdAt' => $decodedOutput['menuMenus'][3]['createdAt'],
                        'updatedAt' => $decodedOutput['menuMenus'][3]['updatedAt'],
                    ]
                    ],
                    'action' => 'viewMenuMenus',
                    'security' => [
                        'security' => '1'
                    ]
                ];            
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals($expectedResult, $decodedOutput);    
        }
        public function test018ViewMenuMenusOwner(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'viewMenuMenus',
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            $expectedResult = [
                'status' => 'success',
                'menuMenus' => [
                    [
                        'menuId' => 3,
                        'menuName' => 'Test Menu 2',
                        'menuDescription' => 'Test Description 2',
                        'isActive' => 0,
                    ],
                    [
                        'menuId' => 4,
                        'menuName' => 'Test Menu 2',
                        'menuDescription' => 'Test Description 2',
                        'isActive' => 1,
                    ]
                ],
                'action' => 'viewMenuMenus',
                'security' => [
                    'security' => '1'
                ]
            ];
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals($expectedResult, $decodedOutput);
        }
        public function test019ViewMenuMenusPublic(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 0;         // Role Value (0 = Public)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'viewMenuMenus',
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            $expectedResult = [
                'status' => 'success',
                'menuMenus' => [
                    [
                        'menuName' => 'Test Menu 2',
                        'menuDescription' => 'Test Description 2'
                    ]
                ],
                'security' => [
                    'security' => '1'
                ],
                'action' => 'viewMenuMenus'
            ];
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals($expectedResult, $decodedOutput);
        }
        public function test020DuplicateMenuMenusSysAdmin(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'duplicateMenuMenus',
                'menuMenus' => [
                    'menueId' => 7
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        // Test Category
        public function test021InsertMenuCategoriesSysAdmin(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertIntoMenuCategories',
                'menuCategories' => [
                    'name' => 'Test Category',
                    'description' => 'Test Description',
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test022InsertMenuCategoriesOwner(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertIntoMenuCategories',
                'menuCategories' => [
                    'menuId' => 4,
                    'name' => 'Bergers',
                    'description' => 'Test Description',
                    'isActive' => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Record inserted successfully', $decodedOutput['message']);

            // Check if the record was inserted correctly
            $stmt = $this->mockPdo->query("SELECT * FROM menu_categories WHERE category_name = 'Bergers' and id = 1");
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertNotEmpty($result, "Record not found in the database.");
            $this->assertEquals('Bergers', $result['category_name']);
            $this->assertEquals('Test Description', $result['category_description']);
            $this->assertEquals(1, $result['is_active']);
            $this->assertEquals(0, $result['is_deleted']);
        }
        public function test023InsertMenuCategoriesOwnerWithNoMenuId(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertIntoMenuCategories',
                'menuCategories' => [
                    'name' => 'Bergers',
                    'description' => 'Test Description',
                    'isActive' => 1
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('menuId is required', $decodedOutput['message']);
        }
        public function test024InsertMenuCategoriesPublic(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 0;         // Role Value (0 = Public)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertIntoMenuCategories',
                'menuCategories' => [
                    'name' => 'Bergers',
                    'description' => 'Test Description',
                    'isActive' => 1
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test025InsertMenuCategoriesWithParent(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertIntoMenuCategories',
                'menuCategories' => [
                    'menuId' => 4,
                    'parentId' => 1, // No parent
                    'name' => 'Classic Bergers',
                    'description' => 'Test Description',
                    'isActive' => 1
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
            // Check if the record was inserted correctly
            $stmt = $this->mockPdo->query("SELECT * FROM menu_categories WHERE category_name = 'Classic Bergers' and id = 2");
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertNotEmpty($result, "Record not found in the database.");
            $this->assertEquals('Classic Bergers', $result['category_name']);
            $this->assertEquals('Test Description', $result['category_description']);
            $this->assertEquals(1, $result['is_active']);
            $this->assertEquals(0, $result['is_deleted']);
            $this->assertEquals(1, $result['parent_id'], "Parent ID should be 1");
        }
        public function test026UpdateMenuCategoriesSysAdmin(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuCategories',
                'menuCategories' => [
                    'id' => 2,
                    'name' => 'Gourmet Bergers',
                    'description' => 'Updated Description',
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test027UpdateMenuCategoriesOwner(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuCategories',
                'categories' => [
                    'id' => 1,
                    'name' => 'Gourmet Bergers',
                    'description' => 'Updated Description',
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Update completed successfully', $decodedOutput['message']);

            // check history record
            $stmt = $this->mockPdo->query("SELECT * FROM menu_audit_log WHERE action_type = 'update' AND table_of_source = 'menu_categories' AND action_by = 293");
            $rows = $stmt->fetch(PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals(10, $rows['id']);

            $stmt = $this->mockPdo->query("SELECT * FROM menu_categories WHERE id = 1");
            $rows = $stmt->fetch(PDO::FETCH_ASSOC);
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals('Gourmet Bergers', $rows['category_name']);
            $this->assertEquals('Updated Description', $rows['category_description']);
        }
        public function test028InsertMenuCategoriesOwnerExtrasClassic(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertIntoMenuCategories',
                'menuCategories' => [
                    'menuId' => 4,
                    'parentId' => 1, // No parent
                    'name' => 'Classic Bergers',
                    'description' => 'Test Description',
                    'isActive' => 1
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
            // Check if the record was inserted correctly
            $stmt = $this->mockPdo->query("SELECT * FROM menu_categories WHERE category_name = 'Classic Bergers' and id = 3");
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertNotEmpty($result, "Record not found in the database.");
            $this->assertEquals('Classic Bergers', $result['category_name']);
            $this->assertEquals('Test Description', $result['category_description']);
            $this->assertEquals(1, $result['is_active']);
            $this->assertEquals(0, $result['is_deleted']);
            $this->assertEquals(1, $result['parent_id'], "Parent ID should be 1");

        }
        public function test029InsertMenuCategoriesOwnerExtrasDirty(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertIntoMenuCategories',
                'menuCategories' => [
                    'menuId' => 4,
                    'parentId' => 1, // No parent
                    'name' => 'Dirty Bergers',
                    'description' => 'Test Description',
                    'isActive' => 1
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
            // Check if the record was inserted correctly
            $stmt = $this->mockPdo->query("SELECT * FROM menu_categories WHERE category_name = 'Dirty Bergers' and id = 4");
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertNotEmpty($result, "Record not found in the database.");
            $this->assertEquals('Dirty Bergers', $result['category_name']);
            $this->assertEquals('Test Description', $result['category_description']);
            $this->assertEquals(1, $result['is_active']);
            $this->assertEquals(0, $result['is_deleted']);
            $this->assertEquals(1, $result['parent_id'], "Parent ID should be 1");
        }
        public function test030DeleteMenuCategoriesOwner(): void{
            $_SESSION['id'] = 295;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user
            $_POST = [
                'action' => 'deleteMenuCategories',
                'categories' => [
                    'id' => 4
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Update completed successfully', $decodedOutput['message']);

            // check history record
            $stmt = $this->mockPdo->query("SELECT * FROM menu_audit_log WHERE action_type = 'delete' AND table_of_source = 'menu_categories' AND action_by = 295");
            $rows = $stmt->fetch(PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows['id']); // or var_dump($rows)
            $this->assertEquals(12, $rows['id']);

            $stmt = $this->mockPdo->query("SELECT * FROM menu_categories WHERE id = 4");
            $rows = $stmt->fetch(PDO::FETCH_ASSOC);
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals(1, $rows['is_deleted']);
        }
        public function test031DeleteMenuMenusCategoriesOwner(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user
            // Insert a new Top level Menu
                $_POST = [
                    'action' => 'insertIntoMenuMenus',
                    'menuMenus' => [
                        'name' => 'Breakfast',
                        'description' => 'Breakfast Menu',
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
                // Sql to get the last inserted id

                $stmt = $this->mockPdo->query("SELECT id FROM menu_menus ORDER BY id DESC LIMIT 1");
                $lastInsertedId = $stmt->fetchColumn();
                // Debug output
                //echo "Last Inserted ID: " . $lastInsertedId . "\n"; // or var_dump($lastInsertedId)
                $this->assertNotEmpty($lastInsertedId, "Last inserted ID should not be empty.");
            // Insert a new Category under the Breakfast Menu
                $_POST = [
                    'action' => 'insertIntoMenuCategories',
                    'menuCategories' => [
                        'menuId' => $lastInsertedId, // Use the last inserted ID
                        'name' => 'Pancakes',
                        'description' => 'Pancakes Category',
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
                // Check if the record was inserted correctly
                $stmt = $this->mockPdo->query("SELECT * FROM menu_categories WHERE category_name = 'Pancakes' and is_active = 1 and is_deleted = 0");
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                $this->assertNotEmpty($result, "Record not found in the database.");
                $this->assertEquals('Pancakes', $result['category_name']);
                $this->assertEquals('Pancakes Category', $result['category_description']);
                $this->assertEquals(1, $result['is_active']);
                $this->assertEquals(0, $result['is_deleted']);
                $this->assertEquals($lastInsertedId, $result['menu_id'], "Menu ID should match the last inserted ID");
                // get the last inserted id of the Pancakes Category
                $stmt = $this->mockPdo->query("SELECT id FROM menu_categories ORDER BY id DESC LIMIT 1");
                $lastInsertedCategoryId = $stmt->fetchColumn();
                // Debug output
                //echo "Last Inserted Category ID: " . $lastInsertedCategoryId . "\n"; // or var_dump($lastInsertedCategoryId)
                $this->assertNotEmpty($lastInsertedCategoryId, "Last inserted Category ID should not be empty.");
            // Insert a sub Category to the Pancakes Category
                $_POST = [
                    'action' => 'insertIntoMenuCategories',
                    'menuCategories' => [
                        'menuId' => $lastInsertedId, // Use the last inserted ID
                        'parentId' => $lastInsertedCategoryId, // Use the last inserted Category ID
                        'name' => 'Fruit Pancakes',
                        'category_description' => 'Blueberry Pancakes Category',
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
            // Delete the Breakfast Menu
                $_POST = [
                    'action' => 'deleteMenuMenus',
                    'menus' => [
                        'id' => $lastInsertedId
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Update completed successfully', $decodedOutput['message']);

                // check history record
                $stmt = $this->mockPdo->query("SELECT * FROM menu_audit_log WHERE action_type = 'delete' AND table_of_source = 'menu_menus' AND action_by = 293");
                $rows = $stmt->fetch(PDO::FETCH_ASSOC);
                // Debug output
                //print_r($rows['id']); // or var_dump($rows)
                $this->assertEquals($lastInsertedId, $rows['record_id']);

                // check if the Pancakes Menu is deleted
                $stmt = $this->mockPdo->prepare("SELECT * FROM menu_menus WHERE id = :lastInsertedId");
                $stmt->bindParam(":lastInsertedId", $lastInsertedId, PDO::PARAM_INT);
                $stmt->execute();
                $rows = $stmt->fetch(PDO::FETCH_ASSOC);
                //print_r($rows); //  var_dump($rows);   
                $this->assertEquals(1, $rows['is_deleted']);


                $stmt = $this->mockPdo->prepare("SELECT * FROM menu_categories");
                $stmt->execute();
                $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
                // Debug output
                //echo print_r($rows, true); // or var_dump($rows)
                
                // check if the Pancakes Category is deleted
                $stmt = $this->mockPdo->prepare("SELECT * FROM menu_categories WHERE id = :lastInsertedCategoryId");
                $stmt->bindParam(":lastInsertedCategoryId", $lastInsertedCategoryId, PDO::PARAM_INT);
                $stmt->execute();
                $rows = $stmt->fetch(PDO::FETCH_ASSOC);
                // Debug output
                //print_r($rows); // or var_dump($rows)
                $this->assertEquals(1, $rows['is_deleted']);

                // check if the Fruit Pancakes Category is deleted
                $stmt = $this->mockPdo->prepare("SELECT * FROM menu_categories WHERE parent_id = :lastInsertedCategoryId");
                $stmt->bindParam(":lastInsertedCategoryId", $lastInsertedCategoryId, PDO::PARAM_INT);
                $stmt->execute();
                $rows = $stmt->fetch(PDO::FETCH_ASSOC);
                // Debug output
                //print_r($rows); // or var_dump($rows)
                $this->assertEquals(1, $rows['is_deleted'], "Sub-category should also be deleted when parent is deleted");                
        }
        // Test Menu Items
            public function test032InsertMenuItemOwner(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'insertItemIntoMenu',
                    'menuItems' => [
                        'categoryId' => 1,
                        'name' => 'Cheeseburger',
                        'description' => 'Juicy cheeseburger with lettuce and tomato',
                        'basePrice' => 9.99,
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $itemId = $decodedOutput[0]['id'];

                $this->assertEquals('success', $decodedOutput[0]['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput[0]['message']);
                $this->assertEquals('success', $decodedOutput[1]['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput[1]['message']);

                // Check if the record was inserted correctly
                $stmt = $this->mockPdo->query("SELECT * FROM menu_items WHERE item_name = 'Cheeseburger' and id = 1");
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                $this->assertNotEmpty($result, "Record not found in the database.");
                $this->assertEquals('Cheeseburger', $result['item_name']);
                $this->assertEquals('Juicy cheeseburger with lettuce and tomato', $result['item_description']);
                $this->assertEquals(9.99, $result['base_price']);
                $this->assertEquals(1, $result['is_active']);
                $this->assertEquals(0, $result['is_deleted']);

                $stmt = $this->mockPdo->prepare("SELECT * FROM menu_category_items WHERE category_id = 1 and item_id = :itemId");
                $stmt->bindParam(":itemId", $itemId, PDO::PARAM_INT);
                $stmt->execute();
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                $this->assertNotEmpty($result, "Record not found in the database.");
                $this->assertEquals(1, $result['category_id']);
                $this->assertEquals($itemId, $result['item_id'], "Item ID should match the last inserted ID");
                $this->assertEquals(0, $result['is_deleted'], "Category Item should not be deleted");
                $this->assertEquals(1, $result['is_active']);
            }
            public function test033InsertMenuItemOwnerNoCategory(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'insertItemIntoMenu',
                    'menuItems' => [
                        'name' => 'Chicken burger',
                        'description' => 'Juicy chicken burger with lettuce and tomato',
                        'basePrice' => 9.99,
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)

                $this->assertEquals('success', $decodedOutput[0]['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput[0]['message']);
            }
            public function test034InsertMenuItemExtraData(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'insertItemIntoMenu',
                    'menuItems' => [
                        'categoryId' => 1,
                        'name' => 'Halloumi burger',
                        'description' => 'Juicy Halloumi burger with lettuce and tomato',
                        'basePrice' => 8.99,
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $itemId = $decodedOutput[0]['id'];

                $this->assertEquals('success', $decodedOutput[0]['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput[0]['message']);
                $this->assertEquals('success', $decodedOutput[1]['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput[1]['message']);
            }
            public function test035InsertMenuItemSysAdmin(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'insertItemIntoMenu',
                    'menuItems' => [
                        'menuId' => 4,
                        'categoryId' => 1,
                        'itemName' => 'Cheeseburger',
                        'itemDescription' => 'Juicy cheeseburger with lettuce and tomato',
                        'basePrice' => 9.99,
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
            }
            public function test036InsertMenuItemOwnerMissingData(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'insertItemIntoMenu',
                    'menuItems' => [
                        'menuId' => 4,
                        'categoryId' => 1,
                        //'itemName' => 'Cheeseburger',
                        // Missing itemDescription
                        //'basePrice' => 9.99,
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('name is required, basePrice is required', $decodedOutput['message']);
            }
            public function test037UpdateItemWithId(): void {
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'updateMenuItems',
                    'items' => [
                        'id' => 1,
                        'name' => 'Updated Cheeseburger',
                        'description' => 'Updated description',
                        'basePrice' => 10.99,
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Update completed successfully', $decodedOutput['message']);

                // Check if the record was updated correctly
                $stmt = $this->mockPdo->query("SELECT * FROM menu_items WHERE id = 1");
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                $this->assertNotEmpty($result, "Record not found in the database.");
                $this->assertEquals('Updated Cheeseburger', $result['item_name']);
                $this->assertEquals('Updated description', $result['item_description']);
                $this->assertEquals(10.99, $result['base_price']);
            }
            public function test038UpdateItemWithoutId(): void {
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'updateMenuItems',
                    'items' => [
                        'name' => 'Updated Cheeseburger',
                        'description' => 'Updated description',
                        'basePrice' => 10.99,
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Missing required Id field: id key: menu_items', $decodedOutput['message']);
            }
            public function test039UpdateItemWithIdNoAuth(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 0;         // Role Value (0 = Public)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'updateMenuItems',
                    'items' => [
                        'id' => 1,
                        'name' => 'Updated Cheeseburger',
                        'description' => 'Updated description',
                        'basePrice' => 10.99,
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
            }
            public function test040UpdateItemWithUnknownId(): void {
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'updateMenuItems',
                    'items' => [
                        'id' => 999, // Unknown ID
                        'name' => 'Updated Cheeseburger',
                        'description' => 'Updated description',
                        'basePrice' => 10.99,
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Record not found', $decodedOutput['message']);
            }
            public function test041UpdateItemWithIdNoChanges(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'updateMenuItems',
                    'items' => [
                        'id' => 1, // Existing ID
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('No valid fields to update', $decodedOutput['message']);
            }
            public function test042UpdateItemNameAndDiscription(): void{
                $stmt = $this->mockPdo->prepare("SELECT * FROM menu_items WHERE id = 1");
                $stmt->execute();
                $rows = $stmt->fetch(PDO::FETCH_ASSOC);
                // Debug output
                //print_r($rows); // or var_dump($rows)
                $this->assertNotEmpty($rows, "Record not found in the database.");
                $this->assertEquals('Updated Cheeseburger', $rows['item_name']);
                $this->assertEquals('Updated description', $rows['item_description']);
                $this->assertEquals(10.99, $rows['base_price']);
                $this->assertEquals(1, $rows['is_active']);
                $this->assertEquals(0, $rows['is_deleted']);
                // Update the item
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role   
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user
                $_POST = [
                    'action' => 'updateMenuItems',
                    'items' => [
                        'id' => 1, // Existing ID
                        'name' => 'Cheeseburger',
                        'description' => 'Description',
                        'basePrice' => 10.99,
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Update completed successfully', $decodedOutput['message']);
                // Check if the record was updated correctly
                $stmt = $this->mockPdo->query("SELECT * FROM menu_items WHERE id = 1");
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                $this->assertNotEmpty($result, "Record not found in the database.");
                $this->assertEquals('Cheeseburger', $result['item_name']);
                $this->assertEquals('Description', $result['item_description']);
                $this->assertEquals(10.99, $result['base_price']);

            }
            public function test043DeleteMenuItemsOwner(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'deleteMenuItems',
                    'items' => [
                        'id' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Update completed successfully', $decodedOutput['message']);

                // check history record
                $stmt = $this->mockPdo->query("SELECT * FROM menu_audit_log WHERE action_type = 'delete' AND table_of_source = 'menu_items' AND action_by = 293");
                $rows = $stmt->fetch(PDO::FETCH_ASSOC);
                // Debug output
                //print_r($rows); // or var_dump($rows)
                $this->assertEquals(1, $rows['record_id']);

                $stmt = $this->mockPdo->query("SELECT * FROM menu_items WHERE id = 1");
                $rows = $stmt->fetch(PDO::FETCH_ASSOC);
                //print_r($rows); // or var_dump($rows)
                $this->assertEquals(1, $rows['is_deleted']);

                $stmt = $this->mockPdo->query("SELECT * FROM menu_category_items WHERE item_id = 1");
                $rows = $stmt->fetch(PDO::FETCH_ASSOC);
                // Debug output
                //print_r($rows); // or var_dump($rows)
                $this->assertEquals(1, $rows['is_deleted'], "Category Item should be deleted when Item is deleted");
            }
            public function test044DeleteMenuItemsOwnerRepeatDelete(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'deleteMenuItems',
                    'items' => [
                        'id' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Record already deleted', $decodedOutput['message']);
            }
            public function test045DeleteMenuItemMissingId(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'deleteMenuItems',
                    'items' => [
                        // Missing id
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Missing required Id field: id key: menu_items', $decodedOutput['message']);
            }
            public function test046DeleteMenuItemNoAuth(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 0;         // Role Value (0 = Public)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'deleteMenuItems',
                    'items' => [
                        'id' => 2
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
            }
        // Test Menu Category Items Linking
        //Insert
            public function test047InsertMenuCategoryItemsNoAuth(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user
                $_POST = [
                    'action' => 'insertItemIntoMenuCategory',
                    'menuCategoryItems' => [
                            'categoryId' => 1,
                            'itemId' => '2',
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
            }
            public function test048InsertMenuCategoryItemsMissingItem(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user
                $_POST = [
                    'action' => 'insertItemIntoMenuCategory',
                    'menuCategoryItems' => [
                            'categoryId' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('itemId is required', $decodedOutput['message']);
            }
            public function test049InsertMenuCategoryItemsMissingCategoryId(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user
                $_POST = [
                    'action' => 'insertItemIntoMenuCategory',
                    'menuCategoryItems' => [
                            'itemId' => 2
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('categoryId is required', $decodedOutput['message']);
            }   
            public function test050InsertMenuCategoryItemsOwner(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user
                $_POST = [
                    'action' => 'insertItemIntoMenuCategory',
                    'menuCategoryItems' => [
                            'categoryId' => 1,
                            'itemId' => '2',
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)

                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
                
                // Check if the record was inserted correctly
                $stmt = $this->mockPdo->query("SELECT * FROM menu_category_items WHERE item_id = 2 and category_id = 1");
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                $this->assertNotEmpty($result, "Record not found in the database.");
                $this->assertEquals(1, $result['category_id']);
                $this->assertEquals(2, $result['item_id'], "Item ID should match the last inserted ID");
            }
        //Updates active status
            public function test051UpdateMenuCategoryItemsNoAuth(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'updateMenuCategoryItems',
                    'categoryItems' => [
                        'id' => 3,
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
            }
            public function test052UpdateMenuCategoryItemsMissingId(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'updateMenuCategoryItems',
                    'categoryItems' => [
                        //'id' => 3, // Missing ID
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Missing required Id field: id key: menu_category_items', $decodedOutput['message']);
            }
            public function test053UpdateMenuCategoryItemsMissingIsActive(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'updateMenuCategoryItems',
                    'categoryItems' => [
                        'id' => 3,
                        //'isActive' => 1 // Missing isActive
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('No valid fields to update', $decodedOutput['message']);
            }
            public function test054UpdateMenuCategoryItemsActiveStatus(): void{
                $stmt = $this->mockPdo->query("SELECT * FROM menu_category_items WHERE id = 3");
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                // Debug output
                //echo print_r($result, true); // or var_dump($result)
                $this->assertNotEmpty($result, "Record not found in the database.");
                $this->assertEquals(0, $result['is_active']);
                
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'updateMenuCategoryItems',
                    'categoryItems' => [
                        'id' => 3,
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Update completed successfully', $decodedOutput['message']);

                // Check if the record was updated correctly
                $stmt = $this->mockPdo->query("SELECT * FROM menu_category_items WHERE id = 3");
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                $this->assertNotEmpty($result, "Record not found in the database.");
                $this->assertEquals(1, $result['is_active']);
            }
        //Delete
            public function test055DeleteMenuCategoryItemsNoAuth(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'deleteMenuCategoryItems',
                    'categoryItems' => [
                        'id' => 3
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
            }
            public function test056DeleteMenuCategoryItemsMissingId(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'deleteMenuCategoryItems',
                    'categoryItems' => [
                        // Missing id
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Missing required Id field: id key: menu_category_items', $decodedOutput['message']);
            }
            public function test057DeleteMenuCategoryItemsNoIdExists(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'deleteMenuCategoryItems',
                    'categoryItems' => [
                        'id' => 999 // Non-existing ID
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Record not found', $decodedOutput['message']);
            }
            public function test058DeleteMenuCategoryItemsOwner(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'deleteMenuCategoryItems',
                    'categoryItems' => [
                        'id' => 3
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Update completed successfully', $decodedOutput['message']);

                // check history record
                $stmt = $this->mockPdo->query("SELECT * FROM menu_audit_log WHERE action_type = 'delete' AND table_of_source = 'menu_category_items' AND action_by = 293");
                $rows = $stmt->fetch(PDO::FETCH_ASSOC);
                // Debug output
                //print_r($rows); // or var_dump($rows)
                $this->assertEquals(3, $rows['record_id']);

                $stmt = $this->mockPdo->query("SELECT * FROM menu_category_items WHERE id = 3");
                $rows = $stmt->fetch(PDO::FETCH_ASSOC);
                //print_r($rows); // or var_dump($rows)
                $this->assertEquals(1, $rows['is_deleted']);
            }
            public function test059DeleteMenuCategoryItemsOwnerRepeatDelete(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'deleteMenuCategoryItems',
                    'categoryItems' => [
                        'id' => 3
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Record already deleted', $decodedOutput['message']);
            }
        //Repeat insert
            public function test060InsertMenuCategoryItemsRepeat(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'insertItemIntoMenuCategory',
                    'menuCategoryItems' => [
                            'categoryId' => 1,
                            'itemId' => '2',
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
            }
            public function test061InsertMenuCategoryItemsRepeatDuplicate(): void{
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'insertItemIntoMenuCategory',
                    'menuCategoryItems' => [
                            'categoryId' => 1,
                            'itemId' => '2',
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Record already exists', $decodedOutput['message']);
            }
            public function test062ViewMenuCatergoryItems(): void{
                $stmt = $this->mockPdo->query("SELECT * FROM menu_category_items");
                $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                // Debug output
                //echo print_r($result, true); // or var_dump($result)
                $this->assertEquals(1,1); // Just a placeholder assertion to ensure the test runs
            }
        // Menu menuOptionGroups & menuOptionGroupItems
            // Insert
                public function test063InsertMenuOptionGroupWithItemsNoAuth(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertMenuOptionsSet',
                        'menuOptionGroups' => [
                            'itemId'            => 3,
                            'groupName'         => 'Test Group',
                            'groupDescription'  => 'Test Description',
                            'minSelect'         => 1,
                            'maxSelect'         => 3,
                            'isActive' => 1
                        ],
                        'menuOptionExtra' => [
                                [
                                'extraName' => 'Option 1',
                                'extraDescription' => 'Description 1',
                                'isDefault' => 1,
                                'allowToggleOnly' => 1,
                                'priceAdjustment' => 0.99,
                                'isActive' => 1
                            ],
                            [
                                'extraName' => 'Option 2',
                                'extraDescription' => 'Description 2',
                                'allowToggleOnly' => 1,
                                'isDefault' => 1,
                                'priceAdjustment' => 1.99,
                                'isActive' => 1
                            ]
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
                }
                public function test064InsertMenuOptionExtraNoAuth(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_POST = [
                        'action' => 'insertMenuOptionExtra',
                        'menuOptionExtra' => [
                            'groupId' => 1,
                            'extraName' => 'New Option',
                            'extraDescription' => 'New Description',
                            'isDefault' => 0,
                            'allowToggleOnly' => 0,
                            'priceAdjustment' => 2.99,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
                }
                /*
                Test disabled as we no longer require itemId to create the group first
                public function test065InsertMenuOptionGroupWithItemsNoId(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertMenuOptionsSet',
                        'menuOptionGroups' => [
                            'groupName'         => 'Test Group',
                            'groupDescription'  => 'Test Description',
                            'minSelect'         => 1,
                            'maxSelect'         => 3,
                            'isActive' => 1
                        ],
                        'menuOptionExtra' => [
                                [
                                'extraName' => 'Option 1',
                                'extraDescription' => 'Description 1',
                                'isDefault' => 1,
                                'allowToggleOnly' => 1,
                                'priceAdjustment' => 0.99,
                                'isActive' => 1
                            ],
                            [
                                'extraName' => 'Option 2',
                                'extraDescription' => 'Description 2',
                                'allowToggleOnly' => 1,
                                'isDefault' => 1,
                                'priceAdjustment' => 1.99,
                                'isActive' => 1
                            ]
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']); //  we nolonger require itemId as the group can be created first
                }
                */
                public function test066InsertMenuOptionExtraNoTenantId(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_POST = [
                        'action' => 'insertMenuOptionExtra',
                        'menuOptionExtra' => [
                            //'extraName' => 'New Option',
                            'extraDescription' => 'New Description',
                            'isDefault' => 0,
                            'allowToggleOnly' => 0,
                            'priceAdjustment' => 2.99,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Tenant ID is required', $decodedOutput['message']);
                }
                public function test067InsertMenuOptionExtraNoId(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user
                    $_POST = [
                        'action' => 'insertMenuOptionExtra',
                        'menuOptionExtra' => [
                            //'extraName' => 'New Option',
                            'extraDescription' => 'New Description',
                            'isDefault' => 0,
                            'allowToggleOnly' => 0,
                            'priceAdjustment' => 2.99,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('extraName is required', $decodedOutput['message']);
                }
                public function test068InsertMenuOptionExtra(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertMenuOptionExtra',
                        'menuOptionExtra' => [
                            'extraName' => 'New Option',
                            'extraDescription' => 'New Description',
                            'priceAdjustment' => 2.99
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test069InsertMenuOptionExtraDuplicate(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertMenuOptionExtra',
                        'menuOptionExtra' => [
                            'extraName' => 'New Option',
                            'extraDescription' => 'New Description',
                            'priceAdjustment' => 2.99
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Record already exists', $decodedOutput['message']);
                }
                public function test070InsertMenuOptionGroupWithItems(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertMenuOptionsSet',
                        'menuOptionGroups' => [
                            'groupName'         => 'Test Group',
                            'groupDescription'  => 'Test Description',
                            'minSelect'         => 1,
                            'maxSelect'         => 3,
                            'isActive' => 1
                        ],
                        'menuOptionExtra' => [
                                [
                                'extraName' => 'Option a1',
                                'extraDescription' => 'Description a1',
                                'isDefault' => 1,
                                'allowToggleOnly' => 1,
                                'priceAdjustment' => 0.99,
                                'isActive' => 1
                            ],
                            [
                                'extraName' => 'Option a2',
                                'extraDescription' => 'Description a2',
                                'allowToggleOnly' => 1,
                                'isDefault' => 1,
                                'priceAdjustment' => 1.99,
                                'isActive' => 1
                            ]
                        ],
                        'menuOptionJoins' => [
                            [
                                'extraId' => 1,
                                'isActive' => 1,
                                'isDefault' => 0,
                                'priceAdjustment' => 3.99,
                            ]
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_groups");
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                    //echo print_r($result, true); // Debug output

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_extra");
                    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    //echo print_r($items, true); // Debug output
                    
                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_joins");
                    $joins = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    //echo print_r($joins, true); // Debug output
                }  
                public function test071InsertMenuOptionGroupWithAddtinalItems(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertMenuOptionsSet',
                        'menuOptionGroups' => [
                            'itemId'            => 3,
                            'groupName'         => 'Test Group',
                            'groupDescription'  => 'Test Description',
                            'minSelect'         => 1,
                            'maxSelect'         => 1,
                            'isActive' => 1
                        ],
                        'menuOptionExtra' => [
                                [
                                'extraName' => 'Beef',
                                'extraDescription' => 'Beef burger',
                                'isDefault' => 1,
                                'allowToggleOnly' => 1,
                                'priceAdjustment' => 0.99,
                                'isActive' => 1
                            ],
                            [
                                'extraName' => 'Chicken',
                                'extraDescription' => 'chicken burger',
                                'allowToggleOnly' => 1,
                                'isDefault' => 1,
                                'priceAdjustment' => 0.99,
                                'isActive' => 1
                            ]
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test072InsertMenuOptionGroupWithOnlyLinkingData(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertMenuOptionsSet',
                        'menuOptionGroups' => [
                            'itemId'            => 3,
                            'groupName'         => 'Test Group',
                            'groupDescription'  => 'Test Description',
                            'minSelect'         => 1,
                            'maxSelect'         => 1,
                            'isActive' => 1
                        ],
                        'menuOptionExtra' => [], // No items to insert
                        'menuOptionJoins' => [
                            [
                                'extraId' => 2,
                                'isActive' => 1,
                                'isDefault' => 1,
                                'priceAdjustment' => 0.99,
                            ]
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test073InsertMenuOptionJoinsOnly(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertMenuOptionJoins',
                        'menuOptionJoins' => [
                                'extraId' => 2,
                                'groupId' => 1, 
                                'isActive' => 1,
                                'isDefault' => 1,
                                'priceAdjustment' => 0.99,
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
            // Update
                public function test074UpdateMenuOptionGroupNoAuth(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'updateMenuOptionGroup',
                        'optionGroups' => [
                            'id' => 1,
                            'groupName' => 'Updated Group Name',
                            'groupDescription' => 'Updated Description',
                            'minSelect' => 2,
                            'maxSelect' => 4,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
                }
                public function test075UpdateMenuOptionExtraNoAuth(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_POST = [
                        'action' => 'updateMenuOptionExtra',
                        'optionExtra' => [
                            'id' => 1,
                            'extraName' => 'Updated Option Name',
                            'extraDescription' => 'Updated Description',
                            'isDefault' => 0,
                            'allowToggleOnly' => 0,
                            'priceAdjustment' => 3.99,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
                }
                public function test076UpdateMenuOptionGroupMissingId(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'updateMenuOptionGroup',
                        'optionGroups' => [
                            //'id' => 1, // Missing ID
                            'groupName' => 'Updated Group Name',
                            'groupDescription' => 'Updated Description',
                            'minSelect' => 2,
                            'maxSelect' => 4,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Missing required Id field: id key: menu_option_groups', $decodedOutput['message']);
                }
                public function test077UpdateMenuOptionExtraMissingId(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_POST = [
                        'action' => 'updateMenuOptionExtra',
                        'optionExtra' => [
                            //'id' => 1, // Missing ID
                            'extraName' => 'Updated Option Name',
                            'extraDescription' => 'Updated Description',
                            'isDefault' => 0,
                            'allowToggleOnly' => 0,
                            'priceAdjustment' => 3.99,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Missing required Id field: id key: menu_option_extra', $decodedOutput['message']);
                } 
                public function test078UpdateOptionGroup(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'updateMenuOptionGroup',
                        'optionGroups' => [
                            'id' => 1,
                            'groupName' => 'Updated Group Name',
                            'groupDescription' => 'Updated Description',
                            'minSelect' => 2,
                            'maxSelect' => 4,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test079UpdateOptionItem(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'updateMenuOptionExtra',
                        'optionExtra' => [
                            'id' => 1,
                            'extraName' => 'Updated Option Name',
                            'extraDescription' => 'Updated Description',
                            'isDefault' => 0,
                            'allowToggleOnly' => 0,
                            'priceAdjustment' => 3.99,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test080UpdateOptionJoin(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'updateMenuOptionJoins',
                        'optionJoins' => [
                            'id' => 1,
                            'isActive' => 0
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_joins WHERE id = 1");
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                    // Debug output
                    //echo print_r($result, true); // or var_dump($result)
                    $this->assertEquals(0, $result['is_active'], 'The is_active field should be set to 0');
                }   
        // Delete
                public function test081DeleteOptionGroupNoAuth(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'deleteMenuOptionGroup',
                        'optionGroups' => [
                            'id' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
                }
                public function test082DeleteOptionItemNoAuth(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 1;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_POST = [
                        'action' => 'deleteMenuOptionExtra',
                        'optionExtra' => [
                            'id' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
                }
                public function test083DeleteOptionGroupMissingId(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'deleteMenuOptionGroup',
                        'optionGroups' => [
                            //'id' => 1, // Missing ID
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Missing required Id field: id key: menu_option_groups', $decodedOutput['message']);
                }
                public function test084DeleteOptionItemMissingId(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'deleteMenuOptionExtra',
                        'optionExtra' => [
                            //'id' => 1, // Missing ID
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Missing required Id field: id key: menu_option_extra', $decodedOutput['message']);
                }
                public function test085DeleteOptionItem(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'deleteMenuOptionExtra',
                        'optionExtra' => [
                            'id' => 2
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_extra WHERE id = 2");
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                    $this->assertNotEmpty($result, "Record not found in the database.");
                    $this->assertEquals(1, $result['is_deleted'], "Record should be marked as deleted.");

                }
                public function test086DeleteOptionItemRepeatDelete(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user
                    $_POST = [
                        'action' => 'deleteMenuOptionExtra',
                        'optionExtra' => [
                            'id' => 2
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Record already deleted', $decodedOutput['message']);
                }
                public function test087DeleteOptionGroup(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'deleteMenuOptionGroup',
                        'optionGroups' => [
                            'id' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_groups WHERE id = 1");
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                    $this->assertNotEmpty($result, "Record not found in the database.");
                    $this->assertEquals(1, $result['is_deleted'], "Record should be marked as deleted.");

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_joins WHERE group_id = 1");
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    //echo print_r($result, true); // Debug output
                    $this->assertNotEmpty($result, "No related option extra found in the database.");
                    foreach ($result as $row) {
                        $this->assertEquals(1, $row['is_deleted'], "Related option item should be marked as deleted.");
                        $stmt = $this->mockPdo->prepare("SELECT * FROM menu_option_extra WHERE id = :id");
                        $stmt->bindValue(':id', $row['extra_id'], PDO::PARAM_INT);
                        $stmt->execute();   
                        $itemResult = $stmt->fetch(PDO::FETCH_ASSOC);
                        $this->assertNotEmpty($itemResult, "Related option item not found in the database.");
                        //echo print_r($itemResult, true); // Debug output
                        //echo ($itemResult['is_deleted']);
                        $this->assertEquals(1, $itemResult['is_deleted'], "Related option item should be marked as deleted.");
                    }
                    //echo print_r($result, true); // Debug output

                }
                public function test088DeleteOptionGroupRepeatDelete(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'deleteMenuOptionGroup',
                        'optionGroups' => [
                            'id' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('Record already deleted', $decodedOutput['message']);
                }
        // uses cases of option items and groups
                public function test089SetupForTests(): void {
                    // This function is used to set up the database for testing
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user
                    $_POST = [
                        'action' => 'insertMenuOptionsSet',
                        'menuOptionGroups' => [
                            'itemId' => 3, // Assuming itemId 3 exists
                            'groupName' => 'Test Group',
                            'groupDescription' => 'Test Description',
                            'minSelect' => 1,
                            'maxSelect' => 1,
                            'isActive' => 1
                        ],
                        'menuOptionExtra' => [
                            [
                                'extraName' => 'Test Option 1',
                                'extraDescription' => 'Test Description 1',
                                'isDefault' => 1,
                                'allowToggleOnly' => 1,
                                'priceAdjustment' => 0.99,
                                'isActive' => 1
                            ],
                            [
                                'extraName' => 'Test Option 2',
                                'extraDescription' => 'Test Description 2',
                                'allowToggleOnly' => 1,
                                'isDefault' => 1,
                                'priceAdjustment' => 0.99,
                                'isActive' => 1
                            ],
                            [   
                                'extraName' => 'Test Option 3',
                                'extraDescription' => 'Test Description 3',
                                'allowToggleOnly' => 1,
                                'isDefault' => 1,
                                'priceAdjustment' => 0.99,
                                'isActive' => 1
                            ],
                            [
                                'extraName' => 'Test Option 4',
                                'extraDescription' => 'Test Description 4',
                                'allowToggleOnly' => 1,
                                'isDefault' => 1,
                                'priceAdjustment' => 0.99,
                                'isActive' => 1
                            ]
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];

                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)

                    $this->assertEquals('success', $decodedOutput['status']);

                    // This function is used to set up the database for testing
                
                    $_POST = [
                        'action' => 'insertMenuOptionsSet',
                        'menuOptionGroups' => [
                            'itemId' => 3, // Assuming itemId 3 exists
                            'groupName' => 'Test Group',
                            'groupDescription' => 'Test Description',
                            'minSelect' => 1,
                            'maxSelect' => 1,
                            'isActive' => 1
                        ],
                        'menuOptionExtra' => [],
                        'menuOptionJoins' => [
                            [
                                'extraId' => 6,
                                'isActive' => 1,
                                'priceAdjustment' => 0.99,
                                'isDefault' => 1

                            ],
                            [
                                'extraId' => 7,
                                'isActive' => 1,
                                'priceAdjustment' => 0.99,
                                'isDefault' => 1
                            ],
                            [
                                'extraId' => 8,
                                'isActive' => 1,
                                'priceAdjustment' => 0.99,
                                'isDefault' => 1
                            ],
                            [
                                'extraId' => 9,
                                'isActive' => 1,
                                'priceAdjustment' => 0.99,
                                'isDefault' => 1
                            ]
                        ],
                            
                        'debug' => 'CSD' // Add debug flag to the request
                    ];

                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                    
                    $_POST = [
                        'action' => 'insertMenuOptionsSet',
                        'menuOptionGroups' => [
                            'itemId' => 3, // Assuming itemId 3 exists
                            'groupName' => 'Test Group 4',
                            'groupDescription' => 'Test Description',
                            'minSelect' => 1,
                            'maxSelect' => 1,
                            'isActive' => 1
                        ],
                        'menuOptionExtra' => [],
                        'menuOptionJoins' => [
                            [
                                'extraId' => 8,
                                'isActive' => 1,
                                'priceAdjustment' => 0.99,
                                'isDefault' => 1
                            ],
                            [
                                'extraId' => 9,
                                'isActive' => 1,
                                'priceAdjustment' => 0.99,
                                'isDefault' => 1
                            ]
                        ],
                            
                        'debug' => 'CSD' // Add debug flag to the request
                    ];

                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_groups WHERE id = 6");
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    $this->assertNotEmpty($result, "No option groups found in the database.");
                    $this->assertCount(1, $result, "There should be exactly one option group with id 6.");
                    //echo print_r($result, true); // Debug output

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_joins WHERE group_id = 6");
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    //echo print_r($result, true); // Debug output
                    $this->assertNotEmpty($result, "No option joins found for group_id 6.");
                    $this->assertCount(2, $result, "There should be exactly two option joins for group_id 6.");

                }
                public function test090GetCurrentDbLists(): void{
                    $sql = "select 
                                mito.id                     as item_to_option__id,
                                mito.item_id                as item_to_option__item_id,
                                mito.group_id               as item_to_option__group_id,
                                mito.is_active              as item_to_option__is_active,
                                mito.is_deleted             as item_to_option__is_deleted,
                                mito.created_at             as item_to_option__created_at,
                                mito.updated_at             as item_to_option__updated_at,
                                mog.id                      as group__id, 
                                mog.group_name              as group__name,
                                mog.group_description       as group_description,
                                mog.min_select              as group__min_select,
                                mog.max_select              as group__max_select,
                                mog.is_active               as group__is_active,
                                mog.is_deleted              as group__is_deleted,
                                mog.created_at              as group__created_at,
                                mog.updated_at              as group__updated_at,
                                moj.id                      as join__id, 
                                moj.group_id                as join__group_id,
                                moj.extra_id                as join__extra_id,
                                moj.is_active               as join__is_active,
                                moj.is_deleted              as join__is_deleted,
                                moj.created_at              as join__created_at,
                                moj.updated_at              as join__updated_at,
                                moi.id                      as extra__id,
                                moi.extra_name              as extra__extra_name,
                                moi.extra_description       as extra__extra_description,
                                moj.is_default              as extra__is_default,
                                moj.price_adjustment        as extra__price_adjustment,
                                moi.is_active               as extra__is_active,
                                moi.is_deleted              as extra__is_deleted,
                                moi.created_at              as extra__created_at,
                                moi.updated_at              as extra__updated_at
                            from menu_option_groups mog
                            left join menu_option_joins moj on mog.id = moj.group_id
                            left join menu_option_extra moi on moj.extra_id = moi.id
                            left join menu_item_to_options mito on mog.id = mito.group_id";
                    $stmt = $this->mockPdo->query($sql);
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    // Debug output
                    //echo print_r($result, true); // or var_dump($result)
                    $this->assertNotEmpty($result, "No option groups found in the database.");

                }      
                public function test091DisableOptionItem6(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'updateMenuOptionExtra',
                        'optionExtra' => [
                            'id' => 6,
                            'isActive' => 0 // Set isActive to 0 to mark as inactive
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_extra WHERE id = 2");
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                    $this->assertNotEmpty($result, "Record not found in the database.");
                    $this->assertEquals(0, $result['is_active'], "Record should be marked as inactive.");

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_joins WHERE extra_id = 6");
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    $this->assertNotEmpty($result, "No related option joins found in the database.");
                    // loop through the results to check if they are marked as inactive
                    foreach ($result as $row) {
                        $this->assertEquals(0, $row['is_active'], "Related option join should be marked as inactive.");
                    }
                }
                public function test092DeleteOptionItem7(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'deleteMenuOptionExtra',
                        'optionExtra' => [
                            'id' => 7
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_extra WHERE id = 7");
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                    $this->assertNotEmpty($result, "Record not found in the database.");
                    $this->assertEquals(1, $result['is_deleted'], "Record should be marked as deleted.");

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_joins WHERE extra_id = 7");
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    $this->assertNotEmpty($result, "No related option joins found in the database.");
                    // loop through the results to check if they are marked as deleted
                    foreach ($result as $row) {
                        $this->assertEquals(1, $row['is_deleted'], "Related option join should be marked as deleted.");
                    }
                }
                public function test093DeleteOptionGroup6(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'deleteMenuOptionGroup',
                        'optionGroups' => [
                            'id' => 6
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_groups WHERE id = 6");
                    $result = $stmt->fetch(PDO::FETCH_ASSOC);
                    //echo print_r($result, true); // Debug output
                    $this->assertNotEmpty($result, "Record not found in the database.");
                    $this->assertEquals(1, $result['is_deleted'], "Record should be marked as deleted.");

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_joins WHERE group_id = 6");
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    //echo print_r($result, true); // Debug output
                    $this->assertNotEmpty($result, "No related option joins found in the database.");
                    $this->assertCount(2, $result, "There should be exactly two related option joins found.");
                    // loop through the results to check if they are marked as deleted
                    foreach ($result as $row) {
                        $this->assertEquals(1, $row['is_deleted'], "Related option join should be marked as deleted.");
                        //echo print_r($itemResult, true); // Debug output  
                    }
                }
                public function test094GetCurrentDbListsv2(): void{
                    $sql = "select
                                mito.id                     as item_to_option__id,
                                mito.item_id                as item_to_option__item_id,
                                mito.group_id               as item_to_option__group_id,
                                mito.is_active              as item_to_option__is_active,
                                mito.is_deleted             as item_to_option__is_deleted,
                                mito.created_at             as item_to_option__created_at,
                                mito.updated_at             as item_to_option__updated_at, 
                                mog.id                      as group__id, 
                                mog.group_name              as group__name,
                                mog.group_description       as group_description,
                                mog.min_select              as group__min_select,
                                mog.max_select              as group__max_select,
                                mog.is_active               as group__is_active,
                                mog.is_deleted              as group__is_deleted,
                                mog.created_at              as group__created_at,
                                mog.updated_at              as group__updated_at,
                                moj.id                      as join__id, 
                                moj.group_id                as join__group_id,
                                moj.extra_id                as join__extra_id,
                                moj.is_active               as join__is_active,
                                moj.is_deleted              as join__is_deleted,
                                moj.created_at              as join__created_at,
                                moj.updated_at              as join__updated_at,
                                moi.id                      as item__id,
                                moi.extra_name              as item__extra_name,
                                moi.extra_description       as item__extra_description,
                                moj.is_default              as item__is_default,
                                moi.price_adjustment        as item__price_adjustment,
                                moi.is_active               as item__is_active,
                                moi.is_deleted              as item__is_deleted,
                                moi.created_at              as item__created_at,
                                moi.updated_at              as item__updated_at
                            from menu_option_groups mog
                            left join menu_option_joins moj on mog.id = moj.group_id
                            left join menu_option_extra moi on moj.extra_id = moi.id
                            left join menu_item_to_options mito on mog.id = mito.group_id";
                    $stmt = $this->mockPdo->query($sql);
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    // Debug output
                    //echo print_r($result, true); // or var_dump($result)
                    $this->assertNotEmpty($result, "No option groups found in the database.");

                } 
            // Need to test what happens when things get deleted  
        // Menu Test Data for view "3"
            public function test095UpdateMenuThreeToActive(): void {
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'updateMenuMenus',
                    'menus' => [
                        'id' => 3,
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Update completed successfully', $decodedOutput['message']);

                // Check if the record was updated correctly
                $stmt = $this->mockPdo->query("SELECT * FROM menu_menus WHERE id = 3");
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                $this->assertNotEmpty($result, "Record not found in the database.");
                $this->assertEquals(1, $result['is_active']);
            }
            public function test096ViewMenuThreeIsActive(): void{
                $stmt = $this->mockPdo->query("SELECT `menu_name`, `menu_description` FROM menu_menus WHERE tenant_id = :tenantId AND is_deleted = 0 and is_active = 1 order by is_deleted, id desc");
                $stmt->bindValue(':tenantId', 1, PDO::PARAM_INT);
                $stmt->execute();
                // Fetch the result
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                // Debug output
                //echo print_r($result, true); // or var_dump($result)
                $this->assertNotEmpty(1,1);
            }
            public function test097InsertMenuCategoriesOwnerThree(): void {
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'insertIntoMenuCategories',
                    'menuCategories' => [
                        'menuId' =>3,
                        'name' => 'Bergers',
                        'description' => 'Test Description',
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
                // Check if the record was inserted correctly
                $stmt = $this->mockPdo->query("SELECT * FROM menu_categories WHERE menu_id = 3 AND category_name = 'Bergers'");
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                $this->assertNotEmpty($result, "Record not found in the database.");
                $this->assertEquals(3, $result['menu_id']);
                $this->assertEquals('Bergers', $result['category_name']);
                $this->assertEquals('Test Description', $result['category_description']);
                $this->assertEquals(1, $result['is_active'], "Category should be active");
            }
            public function test098InsertMenuCategoriesOwnerThreeExtraCat(): void {
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'insertIntoMenuCategories',
                    'menuCategories' => [
                        'menuId' =>3,
                        'name' => 'Bangers',
                        'description' => 'Test Description',
                        'isActive' => 1
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
                // Check if the record was inserted correctly
                $stmt = $this->mockPdo->query("SELECT * FROM menu_categories WHERE menu_id = 3 AND category_name = 'Bangers'");
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                $this->assertNotEmpty($result, "Record not found in the database.");
                $this->assertEquals(3, $result['menu_id']);
                $this->assertEquals('Bangers', $result['category_name']);
                $this->assertEquals('Test Description', $result['category_description']);
                $this->assertEquals(1, $result['is_active'], "Category should be active");
            }
            public function test099InsertMenuCategoriesOwnerThreeChiledCat(): void {
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user
                $_POST = [
                    'action' => 'insertIntoMenuCategories',
                    'menuCategories' => [
                        'menuId' =>3,
                        'name' => 'Gormay Bergers',
                        'description' => 'Test Description',
                        'isActive' => 1,
                        'parentId' => 7 // Assuming 1 is the ID of the parent category
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
            }
            public function test100InsertMenuCategoriesOwnerThreeChiledCat1(): void {
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user
                $_POST = [
                    'action' => 'insertIntoMenuCategories',
                    'menuCategories' => [
                        'menuId' =>3,
                        'name' => 'Meaty Ones',
                        'description' => 'Test Description',
                        'isActive' => 1,
                        'parentId' => 9 // Assuming 1 is the ID of the parent category
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
            }
            public function test101InsertMenuCategoriesOwnerThreeChiledCat2(): void {
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user
                $_POST = [
                    'action' => 'insertIntoMenuCategories',
                    'menuCategories' => [
                        'menuId' =>3,
                        'name' => 'Vegan Ones',
                        'description' => 'Test Description',
                        'isActive' => 1,
                        'parentId' => 9 // Assuming 1 is the ID of the parent category
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
            }
            public function test102InsertMenuCategoriesOwnerThreeToBeDeleted(): void {
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'insertIntoMenuCategories',
                    'menuCategories' => [
                        'menuId' =>3,
                        'name' => 'Fish and Chips',
                        'description' => 'Test Description',
                        'isActive' => 0
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Record inserted successfully', $decodedOutput['message']);
            }
            public function test103InsertMenuCategoriesOwnerThreeToBeDisabled(): void {
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                $_POST = [
                    'action' => 'insertIntoMenuCategories',
                    'menuCategories' => [
                        'menuId' => 3,
                        'name' => 'Chicken Platters',
                        'description' => 'Test Description',
                        'isActive' => 0
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
            }
            public function test104DeleteMenuCategoriesOwnerThree(): void {
                $_SESSION['id'] = 293;              // User ID
                $_SESSION['roleValue'] = 4;
                $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user         
                $_POST = [
                    'action' => 'deleteMenuCategories',
                    'categories' => [
                        'id' => 13
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertEquals('Update completed successfully', $decodedOutput['message']);
            }
            // insert menu items
                public function test105InsertMenuThreeItemOneSausageAndMash(): void {
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertItemIntoMenu',
                        'menuItems' => [
                            'categoryId' => 8,
                            'name' => 'Sasuage and Mash With Onion Gravy',
                            'description' => 'Traditional British dish with sausages, mashed potatoes, and onion gravy',
                            'basePrice' => 9.99,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];

                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test106InsertMenuThereItemsTwoSuasageAndMash(): void {
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertItemIntoMenu',
                        'menuItems' => [
                            'categoryId' => 8,
                            'name' => 'Apple and Honey Sasuage and Mash With Onion Gravy',
                            'description' => 'Traditional British dish with sausages, mashed potatoes, and onion gravy with a twist of apple and honey',
                            'basePrice' => 10.59,
                            'isActive' => 0
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];

                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test107InsertMenuThereItemsThreeSuasageAndMash(): void {
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertItemIntoMenu',
                        'menuItems' => [
                            'categoryId' => 8,
                            'name' => 'Beef Sasuage and Mash With Onion Gravy',
                            'description' => 'Traditional British dish with beef sausages, mashed potatoes, and onion gravy',
                            'basePrice' => 10.59
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];

                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test108InsertMenuThereItemsFourFishAndChips(): void {
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertItemIntoMenu',
                        'menuItems' => [
                            'categoryId' => 12,
                            'name' => 'Cod and chips',
                            'description' => 'Traditional British dish with cod fish and chips',
                            'basePrice' => 9.59,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];

                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test109InsertMenuThereItemsFiveFishAndChips(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertItemIntoMenu',
                        'menuItems' => [
                            'categoryId' => 12,
                            'name' => 'Haddock and chips',
                            'description' => 'Traditional British dish with haddock fish and chips',
                            'basePrice' => 9.59,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];

                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test110InsertMenuThereItemsSixBurger(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertItemIntoMenu',
                        'menuItems' => [
                            'categoryId' => 10,
                            'name' => 'Cheese Burger',
                            'description' => 'Traditional British dish with cheese burger',
                            'basePrice' => 9.59,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];

                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test111InsertMenuThereItemsSevenBurger(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertItemIntoMenu',
                        'menuItems' => [
                            'categoryId' => 10,
                            'name' => 'Bacon Burger',
                            'description' => 'Traditional British dish with bacon burger',
                            'basePrice' => 9.59,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];

                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test112InsertMenuThereItemsEightBurger(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertItemIntoMenu',
                        'menuItems' => [
                            'categoryId' => 11,
                            'name' => 'Vegan Burger',
                            'description' => 'Traditional British dish with vegan burger',
                            'basePrice' => 9.59,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];

                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test113InsertMenuThereItemsNineBurger(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertItemIntoMenu',
                        'menuItems' => [
                            'categoryId' => 11,
                            'name' => 'Hallumi Burger',
                            'description' => 'Traditional British dish with hallumi burger',
                            'basePrice' => 9.59,
                            'isActive' => 1
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];

                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
                public function test114DeleteMenuThereItemsNineBurger(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'deleteMenuItems',
                        'items' => [
                            'id' => 12
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                    $this->assertEquals('Update completed successfully', $decodedOutput['message']);

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_items WHERE id = 12");
                    $rows = $stmt->fetch(PDO::FETCH_ASSOC);
                    //print_r($rows); // or var_dump($rows)
                    $this->assertEquals(1, $rows['is_deleted']);
                }
                public function test115InsertOptionForBurgers(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                   $_POST = [
                        'action' => 'insertMenuOptionsSet',
                        'menuOptionGroups' => [
                            'itemId'            => 9,
                            'groupName'         => 'Double Up',
                            'groupDescription'  => 'Test Description',
                            'minSelect'         => 0,
                            'maxSelect'         => 1,
                            'isActive' => 1
                        ],
                        'menuOptionExtra' => [
                                [
                                'extraName' => 'Beef Burger',
                                'extraDescription' => 'Description 1',
                                'isDefault' => 1,
                                'allowToggleOnly' => 1,
                                'priceAdjustment' => 1.99,
                                'isActive' => 1
                            ],
                            [
                                'extraName' => 'Chicken Burger',
                                'extraDescription' => 'Description 2',
                                'allowToggleOnly' => 1,
                                'isDefault' => 0,
                                'priceAdjustment' => 1.99,
                                'isActive' => 1
                            ],
                            [
                                'extraName' => 'Hallumi Burger',
                                'extraDescription' => 'Description 3',
                                'allowToggleOnly' => 1,
                                'isDefault' => 0,
                                'priceAdjustment' => 1.49,
                                'isActive' => 1
                            ]
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);

                    $stmt = $this->mockPdo->query("SELECT id FROM menu_option_extra WHERE extra_name = 'Beef Burger'");
                    $result = $stmt->fetchAll();
                    $this->assertCount(1, $result);
                    //echo print_r($result, true);
                    $id = $result[0]['id'];

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_joins WHERE extra_id = $id");
                    $result = $stmt->fetchAll();
                    $this->assertCount(1, $result);
                    //echo(print_r($result, true));

                    $_POST = [
                        'action' => 'insertMenuOptionsSet',
                        'menuOptionGroups' => [
                            'itemId'            => 10,
                            'groupName'         => 'Double Up',
                            'groupDescription'  => 'Test Description',
                            'minSelect'         => 0,
                            'maxSelect'         => 1,
                            'isActive' => 1
                        ],
                        'menuOptionJoins' => [
                            [
                                'extraId' => 10,
                                'isActive' => 1,
                                'priceAdjustment' => 1.99,
                                'isDefault' => 1,
                            ],
                            [
                                'extraId' => 11,
                                'isActive' => 1,
                                'priceAdjustment' => 1.99
                            ],
                            [
                                'extraId' => 12,
                                'isActive' => 1,
                                'priceAdjustment' => 1.49
                            ]
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);

                    $_POST = [
                        'action' => 'insertMenuOptionsSet',
                        'menuOptionGroups' => [
                            'itemId'            => 11,
                            'groupName'         => 'Double Up',
                            'groupDescription'  => 'Test Description',
                            'minSelect'         => 0,
                            'maxSelect'         => 1,
                            'isActive' => 1
                        ],
                        'menuOptionJoins' => [
                            [
                                'extraId' => 12,
                                'isActive' => 1,
                                'priceAdjustment' => 1.49
                            ]
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);

                    // This should be a fail test as exra does not exist
                    $_POST = [
                        'action' => 'insertMenuOptionsSet',
                        'menuOptionGroups' => [
                            'itemId'            => 11,
                            'groupName'         => 'Double Up',
                            'groupDescription'  => 'Test Description',
                            'minSelect'         => 0,
                            'maxSelect'         => 1,
                            'isActive' => 1
                        ],
                        'menuOptionJoins' => [
                            [
                                'extraId' => 13,
                                'isActive' => 1,
                                'priceAdjustment' => 1.49
                            ]
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('failed', $decodedOutput['status']);
                    $this->assertEquals('One or more Extra IDs do not exist. Please check and try again.', $decodedOutput['message']);

                }
                public function test116DeleteOptionJoin(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 1;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'deleteMenuOptionJoins',
                        'optionJoins' => [
                            'id' => 18
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                    $this->assertEquals('Update completed successfully', $decodedOutput['message']);

                    $stmt = $this->mockPdo->query("SELECT * FROM menu_option_joins WHERE id = 18");
                    $rows = $stmt->fetch(PDO::FETCH_ASSOC);
                    //print_r($rows); // or var_dump($rows)
                    $this->assertEquals(1, $rows['is_deleted']);
                }
            // New test for checking Tenant ID isolation
                public function test117InsertMenuOptionExtraDuplicateDifferentTenant(): void{
                    $_SESSION['id'] = 293;              // User ID
                    $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
                    $_SESSION['roleTenantId'] = 2;      // Tenant ID for the role
                    $_SESSION['tenantId'] = 2;          // Tenant ID for the user

                    $_POST = [
                        'action' => 'insertMenuOptionExtra',
                        'menuOptionExtra' => [
                            'extraName' => 'New Option',
                            'extraDescription' => 'New Description',
                            'priceAdjustment' => 2.99
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
                    ];
                    list($output, $decodedOutput) = $this->executeFunctionPhp();
                    $decodedOutput = json_decode($output, true);
                    // Debug output
                    //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
                    $this->assertEquals('success', $decodedOutput['status']);
                }
    // Test for updated mapping of menu items to option groups to allow one option group to be used by multiple menu items and still share the same extras
        public function test118InsertMenuItemToOptions(): void{
            // manual insert menu_item_to_options
            $stmt = $this->mockPdo->prepare("INSERT INTO menu_item_to_options 
                                                (item_id, group_id, is_active, is_deleted) 
                                            VALUES 
                                                (9, 1, 1, 0)");
            $stmt->execute();
            $this->assertTrue(true);
        }
        public function test119InsertMenuJoinLink():void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertMenuLinkOptions',
                'menuItemToOptions' => [
                    'itemId'    => 9,
                    'groupId'   => 7,
                    'isActive'  => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
        }
        public function test120InsertMenuJoinLinkNoItem():void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertMenuLinkOptions',
                'menuItemToOptions' => [
                    'groupId'   => 4,
                    'itemId'    => null,
                    'isActive'  => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Item ID not specified', $decodedOutput['message']);
        }
        public function test121InsertMenuJoinLinkNoGroup():void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertMenuLinkOptions',
                'menuItemToOptions' => [
                    'itemId'    => 9,
                    'isActive'  => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Group ID not specified', $decodedOutput['message']);
        }
        public function test022InsertMenuJoinLinkInccoretRole():void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 7;         // Role Value (2 = Staff)
            $_SESSION['roleTenantId'] = 7;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertMenuLinkOptions',
                'menuItemToOptions' => [
                    'itemId'    => 9,
                    'groupId'   => 7,
                    'isActive'  => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test023InsertMenuJoinLinkNoRole():void{
            $_SESSION['id'] = 293;              // User ID              
            unset($_SESSION['roleValue']);        
            unset($_SESSION['roleTenantId']);     
            unset($_SESSION['tenantId']);         

            $_POST = [
                'action' => 'insertMenuLinkOptions',
                'menuItemToOptions' => [
                    'itemId'    => 9,
                    'groupId'   => 7,
                    'isActive'  => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test124InsertMenuJoinLink():void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertMenuLinkOptions',
                'menuItemToOptions' => [
                    'itemId'    => 10,
                    'groupId'   => 8,
                    'isActive'  => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);

            $_POST = [
                'action' => 'insertMenuLinkOptions',
                'menuItemToOptions' => [
                    'itemId'    => 11,
                    'groupId'   => 9,
                    'isActive'  => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);

            $_POST = [
                'action' => 'insertMenuLinkOptions',
                'menuItemToOptions' => [
                    'itemId'    => 3,
                    'groupId'   => 2,
                    'isActive'  => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);

            $_POST = [
                'action' => 'insertMenuLinkOptions',
                'menuItemToOptions' => [
                    'itemId'    => 3,
                    'groupId'   => 3,
                    'isActive'  => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);   
            $_POST = [
                'action' => 'insertMenuLinkOptions',
                'menuItemToOptions' => [
                    'itemId'    => 3,
                    'groupId'   => 4,
                    'isActive'  => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);

            $_POST = [
                'action' => 'insertMenuLinkOptions',
                'menuItemToOptions' => [
                    'itemId'    => 3,
                    'groupId'   => 5,
                    'isActive'  => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']); 

            // manual insert inactive/deleted links

            $sql = " insert into menu_item_to_options 
                        (item_id, group_id, is_active, is_deleted) 
                    values 
                        (3, 1, 0, 1)";
            $stmt = $this->mockPdo->prepare($sql);
            $stmt->execute();
            $this->assertTrue(true);

           $sql = " insert into menu_item_to_options 
                        (item_id, group_id, is_active, is_deleted) 
                    values 
                        (3, 6, 0, 1)";
            $stmt = $this->mockPdo->prepare($sql); 
            $stmt->execute();
            $this->assertTrue(true);          
        }
        public function test125InsertMenuJoinLinkDuplicate():void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'insertMenuLinkOptions',
                'menuItemToOptions' => [
                    'itemId'    => 9,
                    'groupId'   => 7,
                    'isActive'  => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('This menu item is already linked to this option group.', $decodedOutput['message']);
        }
        public function test126DeleteMenuJoin(): void{
            $sql = "select * from menu_option_groups where id = 1";
            $stmt = $this->mockPdo->query($sql);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            //echo print_r($rows); // or var_dump($rows)
            $this->assertGreaterThanOrEqual(1, count($rows));
            
            
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'deleteMenuLinkOptions',
                'itemToOptions' => [
                    'id' => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Update completed successfully', $decodedOutput['message']);

            $stmt = $this->mockPdo->query("SELECT * FROM menu_item_to_options WHERE id = 1");
            $rows = $stmt->fetch(PDO::FETCH_ASSOC);
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals(1, $rows['is_deleted']);

            // Reset the link for other tests
            $stmt = $this->mockPdo->prepare("UPDATE menu_item_to_options SET is_deleted = 0, is_active = 1 WHERE id = 1");
            $stmt->execute();
            $this->assertTrue(true);


        }
        public function test127DeleteMenuJoinNoId(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'deleteMenuLinkOptions',
                'itemToOptions' => [
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Missing required Id field: id key: menu_item_to_options', $decodedOutput['message']);
        }
        public function test128DeleteMenuJoinIncorrectRole(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 1;         // Role Value (2 = Staff)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'deleteMenuLinkOptions',
                'itemToOptions' => [
                    'id' => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test129DeleteMenuJoinNoRole(): void{
            $_SESSION['id'] = 293;              // User ID              
            unset($_SESSION['roleValue']);        
            unset($_SESSION['roleTenantId']);     
            unset($_SESSION['tenantId']);         

            $_POST = [
                'action' => 'deleteMenuLinkOptions',
                'itemToOptions' => [
                    'id' => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test130DeleteMenuJoinNonExistentId(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'deleteMenuLinkOptions',
                'itemToOptions' => [
                    'id' => 9999
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Record not found', $decodedOutput['message']);
        }
        public function test131DeleteMenuJoinDuplicate(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'deleteMenuLinkOptions',
                'itemToOptions' => [
                    'id' => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Update completed successfully', $decodedOutput['message']);

            $_POST = [
                'action' => 'deleteMenuLinkOptions',
                'itemToOptions' => [
                    'id' => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Record already deleted', $decodedOutput['message']);

            $stmt = $this->mockPdo->query("SELECT * FROM menu_item_to_options WHERE id = 1");
            $rows = $stmt->fetch(PDO::FETCH_ASSOC);
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals(1, $rows['is_deleted']);

            // Reset the link for other tests
            $stmt = $this->mockPdo->prepare("UPDATE menu_item_to_options SET is_deleted = 0, is_active = 1 WHERE id = 1");
            $stmt->execute();
            $this->assertTrue(true);
        }
        public function test132UpdateMenuJoinLinkDisable(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuLinkOptions',
                'itemToOptions' => [
                    'id'        => 1,
                    'isActive'  => 0
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Update completed successfully', $decodedOutput['message']);

            $stmt = $this->mockPdo->query("SELECT * FROM menu_item_to_options WHERE id = 1");
            $rows = $stmt->fetch(PDO::FETCH_ASSOC);
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals(0, $rows['is_active']);

            // Reset the link for other tests
            $stmt = $this->mockPdo->prepare("UPDATE menu_item_to_options SET is_active = 1 WHERE id = 1");
            $stmt->execute();
            $this->assertTrue(true);
        }
        public function test133UpdateMenuJoinLinkChangeItemId(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuLinkOptions',
                'itemToOptions' => [
                    'id'        => 1,
                    'itemId'    => 2
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('No valid fields to update', $decodedOutput['message']);
        }
        public function test134UpdateMenuJoinLinkChangeGroupId(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuLinkOptions',
                'itemToOptions' => [
                    'id'        => 1,
                    'groupId'   => 2
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('No valid fields to update', $decodedOutput['message']);
        }
        public function test135UpdateMenuJoinLinkNoId(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuLinkOptions',
                'itemToOptions' => [
                    'isActive'  => 0
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Missing required Id field: id key: menu_item_to_options', $decodedOutput['message']);
        }
        public function test136UpdateMenuJoinLinkIncorrectRole(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 1;         // Role Value (2 = Staff)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuLinkOptions',
                'itemToOptions' => [
                    'id'        => 1,
                    'isActive'  => 0
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test137UpdateMenuJoinLinkUpdateChangeDuplicate(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'updateMenuLinkOptions',
                'itemToOptions' => [
                    'id'        => 1,
                    'isActive'  => 0
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Update completed successfully', $decodedOutput['message']);

            $_POST = [
                'action' => 'updateMenuLinkOptions',
                'itemToOptions' => [
                    'id'        => 1,
                    'isActive'  => 0
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Update completed successfully', $decodedOutput['message']);

            $_POST = [
                'action' => 'updateMenuLinkOptions',
                'itemToOptions' => [
                    'id'        => 1,
                    'isActive'  => 1
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Update completed successfully', $decodedOutput['message']);
        }
        public function test138ViewMenuGroups(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user
            $_GET = [
                'action' => 'viewMenuGroups',
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);

            $sql = "select * from menu_item_to_options";
            $stmt = $this->mockPdo->query($sql);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            //echo print_r($rows); // or var_dump($rows)
            $this->assertGreaterThanOrEqual(1, count($rows));

            $sql = "select * from menu_option_groups where id = 1";
            $stmt = $this->mockPdo->query($sql);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            //echo print_r($rows); // or var_dump($rows)
            $this->assertGreaterThanOrEqual(1, count($rows));
        }
        // View Menu Items
        public function test139ViewSqlData(): void{
            $stmt = $this->mockPdo->query("SELECT
                                                mito.id                 AS mito_id,
                                                moe.id                  AS moe_extra_id, 
                                                mog.id                  AS mog_group_id, 
                                                moj.id                  AS moj_join_id,
                                                mito.item_id            AS mito_item_id,
                                                mito.group_id           AS mito_group_id,
                                                mito.is_active          AS mito_is_active,
                                                mito.is_deleted         AS mito_is_deleted,
                                                moe.tenant_id           AS moe_tenant_id,
                                                moe.extra_name          AS moe_extra_name,
                                                moe.extra_description   AS moe_extra_description,
                                                moe.is_active           AS moe_is_active,
                                                moe.is_deleted          AS moe_is_deleted,
                                                moj.price_adjustment    AS moj_price_adjustment,
                                                moj.is_active           AS moj_is_active,
                                                moj.is_deleted          AS moj_is_deleted,
                                                moj.is_default          AS moj_is_default,
                                                mog.group_name          AS mog_group_name,
                                                mog.group_description   AS mog_group_description,
                                                mog.min_select          AS mog_min_select,
                                                mog.max_select          AS mog_max_select,
                                                mog.is_required         AS mog_is_required,
                                                mog.is_active           AS mog_is_active
                                            FROM menu_option_extra moe
                                            LEFT JOIN menu_option_joins     moj  ON moj.extra_id  = moe.id
                                            LEFT JOIN menu_option_groups    mog  ON moj.group_id  = mog.id
                                            LEFT JOIN menu_item_to_options  mito ON mito.group_id = mog.id 
                                            WHERE moe.tenant_id = 1
                                            ORDER BY moe.id");
            $stmt->execute();
            $extras = $stmt->fetchAll(PDO::FETCH_ASSOC);
            //print_r($extras); // or var_dump($extras)
            $this->assertTrue(true);

        }
        public function test140ViewItemExtras(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_GET = [
                'action' => 'viewItemExtras'
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertCount(8, $decodedOutput['data']);
        }  
        public function test141ViewMenuOwnerNoAuth(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 0;         // Role Value (0 = Public)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'viewAdminMenus',
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test142ViewMenuSysAdminNoAuth(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 0;         // Role Value (0 = Public)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'viewSuperAdminMenus',
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test143ViewMenuPublic(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 0;         // Role Value (0 = Public)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_GET = [
                'action' => 'viewPublicMenus',
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            // Debug output
            $this->assertEquals('success', $decodedOutput['status']);
            $expectedResult = [
                'status' => 'success',
                'menuMenus' => [
                    [
                        'menuName' => 'Test Menu 2',
                        'menuDescription' => 'Test Description 2',
                        'categories' => [
                            [
                                'categoryName' => 'Bergers',
                                'categoryDescription' => 'Test Description',
                                'subCategories' => [
                                    [
                                        'categoryName' => 'Gormay Bergers',
                                        'categoryDescription' => 'Test Description',
                                        'subCategories' => [
                                            [
                                                'categoryName' => 'Meaty Ones',
                                                'categoryDescription' => 'Test Description',
                                                'items' => [
                                                    [
                                                        'itemName' => 'Cheese Burger',
                                                        'itemDescription' => 'Traditional British dish with cheese burger',
                                                        'basePrice' => 9.59,
                                                        'itemId' => 9,
                                                        'options' => [
                                                            [
                                                                'linkId' => 1,
                                                                'groupId' => 1,
                                                                'itemId' => 9,
                                                                'isActive' => 1,
                                                            ],
                                                            [
                                                                'linkId' => 2,
                                                                'groupId' => 7,
                                                                'itemId' => 9,
                                                                'isActive' => 1,
                                                                'optionGroup' =>[
                                                                    'optionId' => 7,
                                                                    'groupName' => 'Double Up',
                                                                    'groupDescription' => 'Test Description',
                                                                    'minSelect' => 0,
                                                                    'maxSelect' => 1,
                                                                    'isRequired' => 0,
                                                                    'extras' => [
                                                                       [
                                                                        'extraId' => 11,
                                                                        'joinIsActive' => 1,
                                                                        'joinIsDeleted' => 0,
                                                                        'extraName' => 'Chicken Burger',
                                                                        'extraDescription' => 'Description 2',
                                                                        'priceAdjustment' => 1.99,
                                                                        'isDefault' => 0,
                                                                        'isDeleted' => 0,
                                                                       ],
                                                                       [
                                                                        'extraId' => 12,
                                                                        'joinIsActive' => 1,
                                                                        'joinIsDeleted' => 0,
                                                                        'extraName' => 'Hallumi Burger',
                                                                        'extraDescription' => 'Description 3',
                                                                        'priceAdjustment' => 1.49,
                                                                        'isDefault' => 0,
                                                                        'isDeleted' => 0,
                                                                       ]
                                                                    ]
                                                                ]
                                                            ]
                                                        ]
                                                    ],
                                                    [
                                                        'itemName' => 'Bacon Burger',
                                                        'itemDescription' => 'Traditional British dish with bacon burger',
                                                        'basePrice' => 9.59,
                                                        'itemId' => 10,
                                                        'options' => [
                                                            [
                                                                'linkId' => 3,
                                                                'groupId' => 8,
                                                                'itemId' => 10,
                                                                'isActive' => 1,
                                                                'optionGroup' =>[
                                                                    'optionId' => 8,
                                                                    'groupName' => 'Double Up',
                                                                    'groupDescription' => 'Test Description',
                                                                    'minSelect' => 0,
                                                                    'maxSelect' => 1,
                                                                    'isRequired' => 0,
                                                                    'extras' => [
                                                                        [
                                                                            'extraId' => 10,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Beef Burger',
                                                                            'extraDescription' => 'Description 1',
                                                                            'priceAdjustment' => 1.99,
                                                                            'isDefault' => 1,
                                                                            'isDeleted' => 0,
                                                                        ],
                                                                        [
                                                                            'extraId' => 11,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Chicken Burger',
                                                                            'extraDescription' => 'Description 2',
                                                                            'priceAdjustment' => 1.99,
                                                                            'isDefault' => 0,
                                                                            'isDeleted' => 0,
                                                                        ],
                                                                        [
                                                                            'extraId' => 12,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Hallumi Burger',
                                                                            'extraDescription' => 'Description 3',
                                                                            'priceAdjustment' => 1.49,
                                                                            'isDefault' => 0,
                                                                            'isDeleted' => 0,
                                                                        ]
                                                                    ]
                                                                ]
                                                            ]
                                                        ]
                                                    ]
                                                ]
                                            ],
                                            [
                                                'categoryName' => 'Vegan Ones',
                                                'categoryDescription' => 'Test Description',
                                                'items' => [
                                                    [
                                                        'itemName' => 'Vegan Burger',
                                                        'itemDescription' => 'Traditional British dish with vegan burger',
                                                        'basePrice' => 9.59,
                                                        'itemId' => 11,
                                                        'options' => [
                                                            [
                                                                'linkId' => 4,
                                                                'groupId' => 9,
                                                                'itemId' => 11,
                                                                'isActive' => 1,
                                                                'optionGroup' =>[
                                                                    'optionId' => 9,
                                                                    'groupName' => 'Double Up',
                                                                    'groupDescription' => 'Test Description',
                                                                    'minSelect' => 0,
                                                                    'maxSelect' => 1,
                                                                    'isRequired' => 0,
                                                                    'extras' => [
                                                                        [
                                                                            'extraId' => 12,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Hallumi Burger',
                                                                            'extraDescription' => 'Description 3',
                                                                            'priceAdjustment' => 1.49,
                                                                            'isDefault' => 0,
                                                                            'isDeleted' => 0,
                                                                        ]
                                                                    ]
                                                                ]
                                                            ]
                                                        ]
                                                    ]
                                                ]
                                            ]
                                        ]
                                    ],
                                ]
                            ],
                            [
                                'categoryName' => 'Bangers',
                                'categoryDescription' => 'Test Description',
                                'items'  =>[
                                    [
                                        'itemName' => 'Sasuage and Mash With Onion Gravy',
                                        'itemDescription' => 'Traditional British dish with sausages, mashed potatoes, and onion gravy',
                                        'basePrice' => 9.99,
                                        'itemId' => 4,
                                    ]
                                ]
                            ],
                        ],
                    ]
                ],
                'security' => [
                    'security' => '1'
                ],
                'action' => 'viewPublicMenus',
            ];
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals($expectedResult, $decodedOutput);
            $this->assertEquals('success', $decodedOutput['status']);

        }
        public function test144ViewMenuOwner(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 4;         // Role Value (4 = Owner)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'viewAdminMenus',
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            $expectedResult = [
                'status' => 'success',
                'menuMenus' => [
                    [
                        'menuName' => 'Test Menu 2',
                        'menuDescription' => 'Test Description 2',
                        'isActive' => 1,
                        'menuId' => 3,
                        'categories' => [
                            [
                                'categoryName' => 'Bergers',
                                'categoryDescription' => 'Test Description',
                                'categoryId' => 7,
                                'isActive' => 1,
                                'parentId' => null,
                                'subCategories' => [
                                    [
                                        'categoryName' => 'Gormay Bergers',
                                        'categoryDescription' => 'Test Description',
                                        'categoryId' => 9,
                                        'isActive' => 1,
                                        'parentId' => 7,
                                        'subCategories' => [
                                            [
                                                'categoryName' => 'Meaty Ones',
                                                'categoryDescription' => 'Test Description',
                                                'categoryId' => 10,
                                                'isActive' => 1,
                                                'parentId' => 9,
                                                'items' => [
                                                    [
                                                        'itemId' => 9,
                                                        'itemName' => 'Cheese Burger',
                                                        'itemDescription' => 'Traditional British dish with cheese burger',
                                                        'basePrice' => 9.59,
                                                        'isActive' => 1,
                                                        'options' =>[
                                                            [
                                                                'linkId' => 1,
                                                                'groupId' => 1,
                                                                'itemId' => 9,    
                                                                'isActive' => 1,                                                            
                                                            ],
                                                            [
                                                                'linkId' => 2,
                                                                'groupId' => 7,
                                                                'itemId' => 9,
                                                                'isActive' => 1,
                                                                'optionGroup' =>[
                                                                    'optionId' => 7,
                                                                    'groupName' => 'Double Up',
                                                                    'groupDescription' => 'Test Description',
                                                                    'minSelect' => 0,
                                                                    'maxSelect' => 1,
                                                                    'isRequired' => 0,
                                                                    'isActive' => 1,
                                                                    'extras' => [
                                                                       [
                                                                        'joinId' => 19,
                                                                        'extraId' => 11,
                                                                        'joinIsActive' => 1,
                                                                        'joinIsDeleted' => 0,
                                                                        'extraName' => 'Chicken Burger',
                                                                        'extraDescription' => 'Description 2',
                                                                        'priceAdjustment' => 1.99,
                                                                        'isDefault' => 0,
                                                                        'isDeleted' => 0,
                                                                        'isActive' => 1,
                                                                       ],
                                                                       [
                                                                        'joinId' => 20,
                                                                        'extraId' => 12,
                                                                        'joinIsActive' => 1,
                                                                        'joinIsDeleted' => 0,
                                                                        'extraName' => 'Hallumi Burger',
                                                                        'extraDescription' => 'Description 3',
                                                                        'priceAdjustment' => 1.49,
                                                                        'isDefault' => 0,
                                                                        'isDeleted' => 0,
                                                                        'isActive' => 1,
                                                                       ]
                                                                    ]
                                                                ]
                                                            ]
                                                        ]
                                                    ],
                                                    [
                                                        'itemId' => 10,
                                                        'itemName' => 'Bacon Burger',
                                                        'itemDescription' => 'Traditional British dish with bacon burger',
                                                        'basePrice' => 9.59,
                                                        'isActive' => 1,
                                                        'options' =>[
                                                            [
                                                                'linkId' => 3,
                                                                'groupId' => 8,
                                                                'itemId' => 10,
                                                                'isActive' => 1,
                                                                'optionGroup' =>[
                                                                    'optionId' => 8,
                                                                    'groupName' => 'Double Up',
                                                                    'groupDescription' => 'Test Description',
                                                                    'minSelect' => 0,
                                                                    'maxSelect' => 1,
                                                                    'isRequired' => 0,
                                                                    'isActive' => 1,
                                                                    'extras' => [
                                                                        [
                                                                            'joinId' => 21,
                                                                            'extraId' => 10,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Beef Burger',
                                                                            'extraDescription' => 'Description 1',
                                                                            'priceAdjustment' => 1.99,
                                                                            'isDefault' => 1,
                                                                            'isDeleted' => 0,
                                                                            'isActive' => 1,
                                                                        ],
                                                                        [
                                                                            'joinId' => 22,
                                                                            'extraId' => 11,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Chicken Burger',
                                                                            'extraDescription' => 'Description 2',
                                                                            'priceAdjustment' => 1.99,
                                                                            'isDefault' => 0,
                                                                            'isDeleted' => 0,
                                                                            'isActive' => 1,
                                                                        ],
                                                                        [
                                                                            'joinId' => 23,
                                                                            'extraId' => 12,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Hallumi Burger',
                                                                            'extraDescription' => 'Description 3',
                                                                            'priceAdjustment' => 1.49,
                                                                            'isDefault' => 0,
                                                                            'isDeleted' => 0,
                                                                            'isActive' => 1,
                                                                        ]
                                                                    ]
                                                                ]
                                                            ]
                                                        ]
                                                    ]
                                                ]
                                            ],
                                            [
                                                'categoryName' => 'Vegan Ones',
                                                'categoryDescription' => 'Test Description',
                                                'categoryId' => 11,
                                                'isActive' => 1,
                                                'parentId' => 9,
                                                'items' => [
                                                    [
                                                        'itemId' => 11,
                                                        'itemName' => 'Vegan Burger',
                                                        'itemDescription' => 'Traditional British dish with vegan burger',
                                                        'basePrice' => 9.59,
                                                        'isActive' => 1,                                                        
                                                        'options' =>[
                                                            [
                                                                'linkId' => 4,
                                                                'groupId' => 9,
                                                                'itemId' => 11,
                                                                'isActive' => 1,
                                                                'optionGroup' =>[
                                                                    'optionId' => 9,
                                                                    'groupName' => 'Double Up',
                                                                    'groupDescription' => 'Test Description',
                                                                    'minSelect' => 0,
                                                                    'maxSelect' => 1,
                                                                    'isRequired' => 0,
                                                                    'isActive' => 1,
                                                                    'extras' => [
                                                                        [
                                                                            'joinId' => 24,
                                                                            'extraId' => 12,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Hallumi Burger',
                                                                            'extraDescription' => 'Description 3',
                                                                            'priceAdjustment' => 1.49,
                                                                            'isDefault' => 0,
                                                                            'isDeleted' => 0,
                                                                            'isActive' => 1,
                                                                        ]
                                                                    ]
                                                                ]
                                                            ]
                                                        ]
                                                    ]
                                                ]
                                            ]
                                        ]
                                    ],
                                ]
                            ],
                            [
                                'categoryName' => 'Bangers',
                                'categoryDescription' => 'Test Description',
                                'categoryId' => 8,
                                'isActive' => 1,
                                'parentId' => null,  
                                'items'     =>[
                                    [
                                        'itemId' => 4,
                                        'itemName' => 'Sasuage and Mash With Onion Gravy',
                                        'itemDescription' => 'Traditional British dish with sausages, mashed potatoes, and onion gravy',
                                        'basePrice' => 9.99,
                                        'isActive' => 1,
                                    ],
                                    [
                                        'itemId' => 5,
                                        'itemName' => 'Apple and Honey Sasuage and Mash With Onion Gravy',
                                        'itemDescription' => 'Traditional British dish with sausages, mashed potatoes, and onion gravy with a twist of apple and honey',
                                        'basePrice' => 10.59,
                                        'isActive' => 0,
                                    ],
                                    [
                                        'itemId' => 6,
                                        'itemName' => 'Beef Sasuage and Mash With Onion Gravy',
                                        'itemDescription' => 'Traditional British dish with beef sausages, mashed potatoes, and onion gravy',
                                        'basePrice' => 10.59,
                                        'isActive' => 0,
                                    ]
                                ]
                            ],
                            [
                                'categoryName' => 'Fish and Chips',
                                'categoryDescription' => 'Test Description',
                                'categoryId' => 12,
                                'isActive' => 0,
                                'parentId' => null,
                                'items' => [
                                    [
                                        'itemId' => 7,
                                        'itemName' => 'Cod and chips',
                                        'itemDescription' => 'Traditional British dish with cod fish and chips',
                                        'basePrice' => 9.59,
                                        'isActive' => 1,
                                    ],
                                    [
                                        'itemId' => 8,
                                        'itemName' => 'Haddock and chips',
                                        'itemDescription' => 'Traditional British dish with haddock fish and chips',
                                        'basePrice' => 9.59,
                                        'isActive' => 1,
                                    ]
                                ]
                            ],
                        ],
                    ],
                    [
                        'menuName' => 'Test Menu 2',
                        'menuDescription' => 'Test Description 2',
                        'isActive' => 0,
                        'menuId' => 4,
                        'categories' => [
                            [
                                'categoryName' => 'Gourmet Bergers',
                                'categoryDescription' => 'Updated Description',
                                'categoryId' => 1,
                                'isActive' => 1,
                                'parentId' => null,
                                'items' =>
                                [
                                    [
                                        'itemId' => 3,
                                        'itemName' => 'Halloumi burger',
                                        'itemDescription' => 'Juicy Halloumi burger with lettuce and tomato',
                                        'isActive' => 1,
                                        'basePrice' => 8.99,
                                        'options'=>[
                                            [
                                                'linkId' => 5,
                                                'groupId' => 2,
                                                'itemId' => 3,
                                                'isActive' => 1,
                                                'optionGroup' =>[
                                                    'optionId' => 2,
                                                    'groupName' => 'Test Group',
                                                    'groupDescription' => 'Test Description',
                                                    'minSelect' => 1,
                                                    'maxSelect' => 1,
                                                    'isRequired' => 0,
                                                    'isActive' => 1,
                                                    'extras' => [
                                                        [
                                                            'joinId' => 4,
                                                            'extraId' => 4,
                                                            'joinIsActive' => 1,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Beef',
                                                            'extraDescription' => 'Beef burger',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                        ],
                                                        [
                                                            'joinId' => 5,
                                                            'extraId' => 5,
                                                            'joinIsActive' => 1,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Chicken',
                                                            'extraDescription' => 'chicken burger',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                        ]
                                                    ]
                                                ]
                                            ],
                                            [
                                                'linkId' => 6,
                                                'groupId' => 3,
                                                'itemId' => 3,
                                                'isActive' => 1,
                                                'optionGroup' =>[
                                                    'optionId' => 3,
                                                    'groupName' => 'Test Group',
                                                    'groupDescription' => 'Test Description',
                                                    'minSelect' => 1,
                                                    'maxSelect' => 1,
                                                    'isRequired' => 0,
                                                    'isActive' => 1
                                                ]
                                            ],
                                            [
                                                'linkId' => 7,
                                                'groupId' => 4,
                                                'itemId' => 3,
                                                'isActive' => 1,
                                                'optionGroup' =>[
                                                    'optionId' => 4,
                                                    'groupName' => 'Test Group',
                                                    'groupDescription' => 'Test Description',
                                                    'minSelect' => 1,
                                                    'maxSelect' => 1,
                                                    'isRequired' => 0,
                                                    'isActive' => 1,
                                                    'extras' =>  [
                                                        [
                                                            'joinId' => 10,
                                                            'extraId' => 8,
                                                            'joinIsActive' => 1,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Test Option 3',
                                                            'extraDescription' => 'Test Description 3',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                        ],
                                                        [
                                                            'joinId' => 11,
                                                            'extraId' => 9,
                                                            'joinIsActive' => 1,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Test Option 4',
                                                            'extraDescription' => 'Test Description 4',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                        ],
                                                        [
                                                            'joinId' => 8,
                                                            'extraId' => 6,
                                                            'joinIsActive' => 0,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Test Option 1',
                                                            'extraDescription' => 'Test Description 1',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 0,
                                                        ]
                                                    ]
                                                ]
                                            ],
                                            [
                                                'linkId' => 8,
                                                'groupId' => 5,
                                                'itemId' => 3,
                                                'isActive' => 1,
                                                'optionGroup' =>[
                                                    'optionId' => 5,
                                                    'groupName' => 'Test Group',
                                                    'groupDescription' => 'Test Description',
                                                    'minSelect' => 1,
                                                    'maxSelect' => 1,
                                                    'isRequired' => 0,
                                                    'isActive' => 1,
                                                    'extras' => [
                                                        [
                                                            'joinId' => 14,
                                                            'extraId' => 8,
                                                            'joinIsActive' => 1,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Test Option 3',
                                                            'extraDescription' => 'Test Description 3',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                        ],
                                                        [
                                                            'joinId' => 15,
                                                            'extraId' => 9,
                                                            'joinIsActive' => 1,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Test Option 4',
                                                            'extraDescription' => 'Test Description 4',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                        ],
                                                        [
                                                            'joinId' => 12,
                                                            'extraId' => 6,
                                                            'joinIsActive' => 0,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Test Option 1',
                                                            'extraDescription' => 'Test Description 1',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 0 ,
                                                        ]
                                                    ]
                                                ]
                                            ]
                                        ]
                                    ],
                                    [
                                        'itemId' => 2,
                                        'itemName' => 'Chicken burger',
                                        'itemDescription' => 'Juicy chicken burger with lettuce and tomato',
                                        'isActive' => 1,
                                        'basePrice' => 9.99,
                                    ]
                                ],
                                'subCategories' => [
                                    [
                                        'categoryName' => 'Classic Bergers',
                                        'categoryDescription' => 'Test Description',
                                        'categoryId' => 2,
                                        'isActive' => 1,
                                        'parentId' => 1,
                                    ],
                                                                        [
                                        'categoryName' => 'Classic Bergers',
                                        'categoryDescription' => 'Test Description',
                                        'categoryId' => 3,
                                        'isActive' => 1,
                                        'parentId' => 1,
                                    ]
                                ]
                            ]
                        ],
                    ]
                ],
                'security' => [
                    'security' => '1'
                ],
                'action' => 'viewAdminMenus',
            ];
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals($expectedResult, $decodedOutput);
        }
        public function test145ViewMenuSysAdmin(): void {
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['roleValue'] = 1;         // Role Value (5 = SysAdmin)
            $_SESSION['roleTenantId'] = 1;      // Tenant ID for the role
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'viewSuperAdminMenus',
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            $expectedResult = [
                'status' => 'success',
                'menuMenus' => [
                    [
                        'menuId' => 3,
                        'tenantId' => 1,
                        'menuName' => 'Test Menu 2',
                        'menuDescription' => 'Test Description 2',
                        'isActive' => 1,
                        'isDeleted' => 0,
                        'createdAt' => $decodedOutput['menuMenus'][0]['createdAt'],
                        'updatedAt' => $decodedOutput['menuMenus'][0]['updatedAt'],
                        'categories' => [
                            [
                                'categoryId' => 7,
                                'menuId' => 3,
                                'parentId' => null,
                                'categoryName' => 'Bergers',
                                'categoryDescription' => 'Test Description',
                                'isDeleted' => 0,
                                'isActive' => 1,
                                'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['createdAt'],
                                'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['updatedAt'],
                                'subCategories' => [
                                    [
                                        'categoryId' => 9,
                                        'menuId' => 3,
                                        'parentId' => 7,
                                        'categoryName' => 'Gormay Bergers',
                                        'categoryDescription' => 'Test Description',
                                        'isActive' => 1,
                                        'isDeleted' => 0,
                                        'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['updatedAt'],
                                        'subCategories' => [
                                            [
                                                'categoryId' => 10,
                                                'menuId' => 3,
                                                'parentId' => 9,
                                                'categoryName' => 'Meaty Ones',
                                                'categoryDescription' => 'Test Description',
                                                'isActive' => 1,
                                                'isDeleted' => 0,
                                                'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['createdAt'],
                                                'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['updatedAt'],
                                                'items' => [
                                                    [
                                                        'itemId' => 9,
                                                        'itemName' => 'Cheese Burger',
                                                        'itemDescription' => 'Traditional British dish with cheese burger',
                                                        'basePrice' => 9.59,
                                                        'nutritionId' => null,
                                                        'isActive' => 1,
                                                        'isDeleted' => 0,
                                                        'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['createdAt'],
                                                        'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['updatedAt'],
                                                        'categoryItemId' => 10,
                                                        'categoryItemIsActive' => 1,
                                                        'categoryItemIsDeleted' => 0,
                                                        'tenantId' => 1,
                                                        'options' => [
                                                            [
                                                                'linkId' => 1,
                                                                'groupId' => 1,
                                                                'itemId' => 9,
                                                                'isActive' => 1,
                                                                'isDeleted' => 0,
                                                                'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['createdAt'],
                                                                'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['updatedAt'],
                                                                'optionGroup' => [
                                                                    'optionId'  => 1,
                                                                    'groupName' => 'Updated Group Name',
                                                                    'groupDescription' => 'Updated Description',
                                                                    'minSelect' => 2,
                                                                    'maxSelect' => 4,
                                                                    'isRequired' => 0,
                                                                    'isActive'  => 0,
                                                                    'isDeleted' => 1,
                                                                    'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['createdAt'],
                                                                    'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['updatedAt'],
                                                                    'tenantId' => 1,
                                                                    'extras' => [
                                                                        [
                                                                            'joinId' => 1,
                                                                            'extraId' => 1,
                                                                            'joinIsActive' => 0,
                                                                            'joinIsDeleted' => 1,
                                                                            'extraName' => 'Updated Option Name',
                                                                            'extraDescription' => 'Updated Description',
                                                                            'priceAdjustment' => 3.99,
                                                                            'isDefault' => 0,
                                                                            'isDeleted' => 1,
                                                                            'isActive' => 0,
                                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][0]['joinCreatedAt'],
                                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][0]['joinUpdatedAt'],
                                                                            'createdAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][0]['createdAt'],
                                                                            'updatedAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][0]['updatedAt'],
                                                                        ],
                                                                        [
                                                                            'joinId' => 2,
                                                                            'extraId' => 2,
                                                                            'joinIsActive' => 0,
                                                                            'joinIsDeleted' => 1,
                                                                            'extraName' => 'Option a1',
                                                                            'extraDescription' => 'Description a1',
                                                                            'priceAdjustment' => 0.99,
                                                                            'isDefault' => 1,
                                                                            'isDeleted' => 1,
                                                                            'isActive' => 0,
                                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][1]['joinCreatedAt'],
                                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][1]['joinUpdatedAt'],
                                                                            'createdAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][1]['createdAt'],
                                                                            'updatedAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][1]['updatedAt'],
                                                                        ],
                                                                        [
                                                                            'joinId' => 7,
                                                                            'extraId' => 2,
                                                                            'joinIsActive' => 0,
                                                                            'joinIsDeleted' => 1,
                                                                            'extraName' => 'Option a1',
                                                                            'extraDescription' => 'Description a1',
                                                                            'priceAdjustment' => 0.99,
                                                                            'isDefault' => 1,
                                                                            'isDeleted' => 1,
                                                                            'isActive' => 0,
                                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][2]['joinCreatedAt'],
                                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][2]['joinUpdatedAt'],
                                                                            'createdAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][2]['createdAt'],
                                                                            'updatedAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][2]['updatedAt'],
                                                                        ],
                                                                        [
                                                                            'joinId' => 3,
                                                                            'extraId' => 3,
                                                                            'joinIsActive' => 0,
                                                                            'joinIsDeleted' => 1,
                                                                            'extraName' => 'Option a2',
                                                                            'extraDescription' => 'Description a2',
                                                                            'priceAdjustment' => 1.99,
                                                                            'isDefault' => 1,
                                                                            'isDeleted' => 1,
                                                                            'isActive' => 0,
                                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][3]['joinCreatedAt'],
                                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][3]['joinUpdatedAt'],
                                                                            'createdAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][3]['createdAt'],
                                                                            'updatedAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][0]['optionGroup']['extras'][3]['updatedAt'],
                                                                        ]
                                                                    ]
                                                                ]
                                                            ],
                                                            [
                                                                'linkId' => 2,
                                                                'groupId' => 7,
                                                                'itemId' => 9,
                                                                'isActive' => 1,
                                                                'isDeleted' => 0,
                                                                'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['createdAt'],
                                                                'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['updatedAt'],
                                                                'optionGroup' => [
                                                                    'optionId'  => 7,
                                                                    'groupName' => 'Double Up',
                                                                    'groupDescription' => 'Test Description',
                                                                    'minSelect' => 0,
                                                                    'maxSelect' => 1,
                                                                    'isRequired' => 0,
                                                                    'isActive'  => 1,
                                                                    'isDeleted' => 0,
                                                                    'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['createdAt'],
                                                                    'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['updatedAt'],
                                                                    'tenantId' => 1,
                                                                    'extras' => [
                                                                        [
                                                                            'joinId' => 19,
                                                                            'extraId' => 11,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Chicken Burger',
                                                                            'extraDescription' => 'Description 2',
                                                                            'priceAdjustment' => 1.99,
                                                                            'isDefault' => 0,
                                                                            'isDeleted' => 0,
                                                                            'isActive' => 1,
                                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['extras'][0]['joinCreatedAt'],
                                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['extras'][0]['joinUpdatedAt'],
                                                                            'createdAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['extras'][0]['createdAt'],
                                                                            'updatedAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['extras'][0]['updatedAt'],
                                                                        ],
                                                                        [
                                                                            'joinId' => 20,
                                                                            'extraId' => 12,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Hallumi Burger',
                                                                            'extraDescription' => 'Description 3',
                                                                            'priceAdjustment' => 1.49,
                                                                            'isDefault' => 0,
                                                                            'isDeleted' => 0,
                                                                            'isActive' => 1,
                                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['extras'][1]['joinCreatedAt'],
                                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['extras'][1]['joinUpdatedAt'],
                                                                            'createdAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['extras'][1]['createdAt'],
                                                                            'updatedAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['extras'][1]['updatedAt'],
                                                                        ],
                                                                        [
                                                                            'joinId' => 18,
                                                                            'extraId' => 10,
                                                                            'joinIsActive' => 0,
                                                                            'joinIsDeleted' => 1,
                                                                            'extraName' => 'Beef Burger',
                                                                            'extraDescription' => 'Description 1',
                                                                            'priceAdjustment' => 1.99,
                                                                            'isDefault' => 1,
                                                                            'isDeleted' => 0,
                                                                            'isActive' => 1,
                                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['extras'][2]['joinCreatedAt'],
                                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['extras'][2]['joinUpdatedAt'],
                                                                            'createdAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['extras'][2]['createdAt'],
                                                                            'updatedAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][0]['options'][1]['optionGroup']['extras'][2]['updatedAt'],
                                                                        ]
                                                                    ]
                                                                ]
                                                            ]
                                                        ]
                                                    ],
                                                    [
                                                        'itemId' => 10,
                                                        'itemName' => 'Bacon Burger',
                                                        'itemDescription' => 'Traditional British dish with bacon burger',
                                                        'basePrice' => 9.59,
                                                        'nutritionId' => null,
                                                        'isActive' => 1,
                                                        'isDeleted' => 0,
                                                        'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['createdAt'],
                                                        'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['updatedAt'],
                                                        'categoryItemId' => 11,
                                                        'categoryItemIsActive' => 1,
                                                        'categoryItemIsDeleted' => 0,
                                                        'tenantId' => 1,
                                                        'options' => [
                                                            [
                                                                'linkId' => 3,
                                                                'groupId' => 8,
                                                                'itemId' => 10,
                                                                'isActive' => 1,
                                                                'isDeleted' => 0,
                                                                'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['createdAt'],
                                                                'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['updatedAt'],
                                                                'optionGroup' => [
                                                                    'optionId'  => 8,
                                                                    'groupName' => 'Double Up',
                                                                    'groupDescription' => 'Test Description',
                                                                    'minSelect' => 0,
                                                                    'maxSelect' => 1,
                                                                    'isRequired' => 0,
                                                                    'isActive'  => 1,
                                                                    'isDeleted' => 0,
                                                                    'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['createdAt'],
                                                                    'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['updatedAt'],
                                                                    'tenantId' => 1,
                                                                    'extras' => [
                                                                        [
                                                                            'joinId' => 21,
                                                                            'extraId' => 10,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Beef Burger',
                                                                            'extraDescription' => 'Description 1',
                                                                            'priceAdjustment' => 1.99,
                                                                            'isDefault' => 1,
                                                                            'isDeleted' => 0,
                                                                            'isActive' => 1,
                                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['extras'][0]['joinCreatedAt'],
                                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['extras'][0]['joinUpdatedAt'],
                                                                            'createdAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['extras'][0]['createdAt'],
                                                                            'updatedAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['extras'][0]['updatedAt'],
                                                                        ],
                                                                        [
                                                                            'joinId' => 22,
                                                                            'extraId' => 11,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Chicken Burger',
                                                                            'extraDescription' => 'Description 2',
                                                                            'priceAdjustment' => 1.99,
                                                                            'isDefault' => 0,
                                                                            'isDeleted' => 0,
                                                                            'isActive' => 1,
                                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['extras'][1]['joinCreatedAt'],
                                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['extras'][1]['joinUpdatedAt'],
                                                                            'createdAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['extras'][1]['createdAt'],
                                                                            'updatedAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['extras'][1]['updatedAt'],
                                                                        ],
                                                                        [
                                                                            'joinId' => 23,
                                                                            'extraId' => 12,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Hallumi Burger',
                                                                            'extraDescription' => 'Description 3',
                                                                            'priceAdjustment' => 1.49,
                                                                            'isDefault' => 0,
                                                                            'isDeleted' => 0,
                                                                            'isActive' => 1,
                                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['extras'][2]['joinCreatedAt'],
                                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['extras'][2]['joinUpdatedAt'],
                                                                            'createdAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['extras'][2]['createdAt'],
                                                                            'updatedAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][0]['items'][1]['options'][0]['optionGroup']['extras'][2]['updatedAt'],
                                                                        ]
                                                                    ]
                                                                ]
                                                            ]
                                                        ]
                                                    ]
                                                ]
                                            ],
                                            [
                                                'categoryId' => 11,
                                                'menuId' => 3,
                                                'parentId' => 9,
                                                'categoryName' => 'Vegan Ones',
                                                'categoryDescription' => 'Test Description',
                                                'isActive' => 1,
                                                'isDeleted' => 0,
                                                'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['createdAt'],
                                                'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['updatedAt'],
                                                'items' => [
                                                    [
                                                        'itemId' => 11,
                                                        'itemName' => 'Vegan Burger',
                                                        'itemDescription' => 'Traditional British dish with vegan burger',
                                                        'basePrice' => 9.59,
                                                        'nutritionId' => null,
                                                        'isActive' => 1,
                                                        'isDeleted' => 0,
                                                        'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['items'][0]['createdAt'],
                                                        'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['items'][0]['updatedAt'],
                                                        'categoryItemId' => 12,
                                                        'categoryItemIsActive' => 1,
                                                        'categoryItemIsDeleted' => 0,
                                                        'tenantId' => 1,
                                                        'options' => [
                                                            [
                                                                'linkId' => 4,
                                                                'groupId' => 9,
                                                                'itemId' => 11,
                                                                'isActive' => 1,
                                                                'isDeleted' => 0,
                                                                'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['items'][0]['options'][0]['createdAt'],
                                                                'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['items'][0]['options'][0]['updatedAt'],
                                                                'optionGroup' => [
                                                                    'optionId'  => 9,
                                                                    'groupName' => 'Double Up',
                                                                    'groupDescription' => 'Test Description',
                                                                    'minSelect' => 0,
                                                                    'maxSelect' => 1,
                                                                    'isRequired' => 0,
                                                                    'isActive'  => 1,
                                                                    'isDeleted' => 0,
                                                                    'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['items'][0]['options'][0]['optionGroup']['createdAt'],
                                                                    'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['items'][0]['options'][0]['optionGroup']['updatedAt'],
                                                                    'tenantId' => 1,
                                                                    'extras' => [
                                                                        [
                                                                            'joinId' => 24,
                                                                            'extraId' => 12,
                                                                            'joinIsActive' => 1,
                                                                            'joinIsDeleted' => 0,
                                                                            'extraName' => 'Hallumi Burger',
                                                                            'extraDescription' => 'Description 3',
                                                                            'priceAdjustment' => 1.49,
                                                                            'isDefault' => 0,
                                                                            'isDeleted' => 0,
                                                                            'isActive' => 1,
                                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['items'][0]['options'][0]['optionGroup']['extras'][0]['joinUpdatedAt'],
                                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['items'][0]['options'][0]['optionGroup']['extras'][0]['joinCreatedAt'],
                                                                            'createdAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['items'][0]['options'][0]['optionGroup']['extras'][0]['createdAt'],
                                                                            'updatedAt'     => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['items'][0]['options'][0]['optionGroup']['extras'][0]['updatedAt'],
                                                                        ]
                                                                    ]
                                                                ]
                                                            ]
                                                        ],
                                                    ],
                                                    [
                                                        'itemId' => 12,
                                                        'itemName' => 'Hallumi Burger',
                                                        'itemDescription' => 'Traditional British dish with hallumi burger',
                                                        'basePrice' => 9.59,
                                                        'nutritionId' => null,
                                                        'isActive' => 0,
                                                        'isDeleted' => 1,
                                                        'createdAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['items'][1]['createdAt'],
                                                        'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][0]['subCategories'][0]['subCategories'][1]['items'][1]['updatedAt'],
                                                        'categoryItemId' => 13,
                                                        'tenantId' => 1,
                                                        'categoryItemIsActive' => 1,
                                                        'categoryItemIsDeleted' => 1,
                                                    ]
                                                ]
                                            ]
                                        ]
                                    ]
                                ]
                            ],
                            [
                                'categoryId' => 8,
                                'menuId' => 3,
                                'parentId' => null,
                                'categoryName' => 'Bangers',
                                'categoryDescription' => 'Test Description',
                                'isDeleted' => 0,
                                'isActive' => 1,
                                'createdAt' => $decodedOutput['menuMenus'][0]['categories'][1]['createdAt'],
                                'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][1]['updatedAt'],
                                'items'     =>[
                                    [
                                        'itemId' => 4,
                                        'itemName' => 'Sasuage and Mash With Onion Gravy',
                                        'itemDescription' => 'Traditional British dish with sausages, mashed potatoes, and onion gravy',
                                        'basePrice' => 9.99,
                                        'nutritionId' => null,
                                        'isActive' => 1,
                                        'isDeleted' => 0,
                                        'createdAt' => $decodedOutput['menuMenus'][0]['categories'][1]['items'][0]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][1]['items'][0]['updatedAt'],
                                        'categoryItemId' => 5,
                                        'tenantId' => 1,
                                        'categoryItemIsActive' => 1,
                                        'categoryItemIsDeleted' => 0,
                                        'tenantId' => 1,
                                    ],
                                    [
                                        'itemId' => 5,
                                        'itemName' => 'Apple and Honey Sasuage and Mash With Onion Gravy',
                                        'itemDescription' => 'Traditional British dish with sausages, mashed potatoes, and onion gravy with a twist of apple and honey',
                                        'basePrice' => 10.59,
                                        'nutritionId' => null,
                                        'isActive' => 0,
                                        'isDeleted' => 0,
                                        'tenantId' => 1,
                                        'createdAt' => $decodedOutput['menuMenus'][0]['categories'][1]['items'][1]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][1]['items'][1]['updatedAt'],
                                        'categoryItemId' => 6,
                                        'categoryItemIsActive' => 0,
                                        'categoryItemIsDeleted' => 0
                                    ],
                                    [
                                        'itemId' => 6,
                                        'itemName' => 'Beef Sasuage and Mash With Onion Gravy',
                                        'itemDescription' => 'Traditional British dish with beef sausages, mashed potatoes, and onion gravy',
                                        'basePrice' => 10.59,
                                        'nutritionId' => null,
                                        'isActive' => 0,
                                        'isDeleted' => 0,
                                        'createdAt' => $decodedOutput['menuMenus'][0]['categories'][1]['items'][2]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][1]['items'][2]['updatedAt'],
                                        'categoryItemId' => 7,
                                        'tenantId' => 1,
                                        'categoryItemIsActive' => 0,
                                        'categoryItemIsDeleted' => 0
                                    ]
                                ]
                            ],
                            [
                                'categoryId' => 12,
                                'menuId' => 3,
                                'parentId' => null,
                                'categoryName' => 'Fish and Chips',
                                'categoryDescription' => 'Test Description',
                                'isDeleted' => 0,
                                'isActive' => 0,
                                'createdAt' => $decodedOutput['menuMenus'][0]['categories'][2]['createdAt'],
                                'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][2]['updatedAt'],
                                'items' => [
                                    [
                                        'itemId' => 7,
                                        'itemName' => 'Cod and chips',
                                        'itemDescription' => 'Traditional British dish with cod fish and chips',
                                        'basePrice' => 9.59,
                                        'nutritionId' => null,
                                        'isActive' => 1,
                                        'isDeleted' => 0,
                                        'createdAt' => $decodedOutput['menuMenus'][0]['categories'][2]['items'][0]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][2]['items'][0]['updatedAt'],
                                        'categoryItemId' => 8,
                                        'categoryItemIsActive' => 1,
                                        'categoryItemIsDeleted' => 0,
                                        'tenantId' => 1,
                                    ],
                                    [
                                        'itemId' => 8,
                                        'itemName' => 'Haddock and chips',
                                        'itemDescription' => 'Traditional British dish with haddock fish and chips',
                                        'basePrice' => 9.59,
                                        'nutritionId' => null,
                                        'isActive' => 1,
                                        'isDeleted' => 0,
                                        'createdAt' => $decodedOutput['menuMenus'][0]['categories'][2]['items'][1]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][2]['items'][1]['updatedAt'],
                                        'categoryItemId' => 9,
                                        'categoryItemIsActive' => 1,
                                        'categoryItemIsDeleted' => 0,
                                        'tenantId' => 1,
                                    ]
                                ]
                            ],
                            [
                                'categoryId' => 13,
                                'menuId' => 3,
                                'parentId' => null,
                                'categoryName' => 'Chicken Platters',
                                'categoryDescription' => 'Test Description',
                                'isDeleted' => 1,
                                'isActive' => 0,
                                'createdAt' => $decodedOutput['menuMenus'][0]['categories'][3]['createdAt'],
                                'updatedAt' => $decodedOutput['menuMenus'][0]['categories'][3]['updatedAt'],
                                
                            ]
                        ]
                    ],
                    [
                        'menuId' => 4,
                        'tenantId' => 1,
                        'menuName' => 'Test Menu 2',
                        'menuDescription' => 'Test Description 2',
                        'isActive' => 0,
                        'isDeleted' => 0,
                        'createdAt' => $decodedOutput['menuMenus'][1]['createdAt'],
                        'updatedAt' => $decodedOutput['menuMenus'][1]['updatedAt'],
                        'categories' => [
                            [
                                'categoryId' => 1,
                                'menuId' => 4,
                                'parentId' => null,
                                'categoryName' => 'Gourmet Bergers',
                                'categoryDescription' => 'Updated Description',
                                'isDeleted' => 0,
                                'isActive' => 1,
                                'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['createdAt'],
                                'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['updatedAt'],
                                'parentId' => null,
                                'items' => [
                                    [
                                        'itemId' => 3,
                                        'itemName' => 'Halloumi burger',
                                        'itemDescription' => 'Juicy Halloumi burger with lettuce and tomato',
                                        'basePrice' => 8.99,
                                        'nutritionId' => null,
                                        'isActive' => 1,
                                        'isDeleted' => 0,
                                        'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][3]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][3]['updatedAt'],
                                        'categoryItemId' => 2,
                                        'categoryItemIsActive' => 1,
                                        'categoryItemIsDeleted' => 0,
                                        'tenantId' => 1,
                                        'options' => [
                                            [
                                                'linkId' => 5,
                                                'groupId' => 2,
                                                'isActive' => 1,
                                                'itemId' => 3,
                                                'isDeleted' => 0,
                                                'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][0]['createdAt'],
                                                'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][0]['updatedAt'],
                                                'optionGroup' => [
                                                    'optionId' => 2,
                                                    'groupName' => 'Test Group',
                                                    'groupDescription' => 'Test Description',
                                                    'minSelect' => 1,
                                                    'maxSelect' => 1,
                                                    'isRequired' => 0,
                                                    'isActive' => 1,
                                                    'isDeleted' => 0,
                                                    'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][0]['optionGroup']['createdAt'],
                                                    'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][0]['optionGroup']['updatedAt'],
                                                    'tenantId' => 1,
                                                    'extras' => [
                                                        [
                                                            'joinId' => 4,
                                                            'extraId' => 4,
                                                            'joinIsActive' => 1,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Beef',
                                                            'extraDescription' => 'Beef burger',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][0]['optionGroup']['extras'][0]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][0]['optionGroup']['extras'][0]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][0]['optionGroup']['extras'][0]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][0]['optionGroup']['extras'][0]['updatedAt'],
                                                        ],
                                                        [
                                                            'joinId' => 5,
                                                            'extraId' => 5,
                                                            'joinIsActive' => 1,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Chicken',
                                                            'extraDescription' => 'chicken burger',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][0]['optionGroup']['extras'][1]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][0]['optionGroup']['extras'][1]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][0]['optionGroup']['extras'][1]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][0]['optionGroup']['extras'][1]['updatedAt'],
                                                        ]
                                                    ]
                                                ]
                                            ],
                                            [
                                                'linkId' => 6,
                                                'groupId' => 3,
                                                'isActive' => 1,
                                                'itemId' => 3,
                                                'isDeleted' => 0,
                                                'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][1]['createdAt'],
                                                'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][1]['updatedAt'],
                                                'optionGroup' => [
                                                    'optionId' => 3,
                                                    'groupName' => 'Test Group',
                                                    'groupDescription' => 'Test Description',
                                                    'minSelect' => 1,
                                                    'maxSelect' => 1,
                                                    'isRequired' => 0,
                                                    'isActive' => 1,
                                                    'isDeleted' => 0,
                                                    'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][1]['optionGroup']['createdAt'],
                                                    'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][1]['optionGroup']['updatedAt'],
                                                    'tenantId' => 1,
                                                    'extras' =>[
                                                        [
                                                            'joinId' => 6,
                                                            'extraId' => 2,
                                                            'joinIsActive' => 0,
                                                            'joinIsDeleted' => 1,
                                                            'extraName' => 'Option a1',
                                                            'extraDescription' => 'Description a1',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 1,
                                                            'isActive' => 0,
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][1]['optionGroup']['extras'][0]['joinUpdatedAt'],
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][1]['optionGroup']['extras'][0]['joinCreatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][1]['optionGroup']['extras'][0]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][1]['optionGroup']['extras'][0]['updatedAt'],
                                                        ]
                                                    ]
                                                ]
                                            ],
                                            [
                                                'linkId' => 7,
                                                'groupId' => 4,
                                                'isActive' => 1,
                                                'itemId' => 3,
                                                'isDeleted' => 0,
                                                'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['createdAt'],
                                                'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['updatedAt'],
                                                'optionGroup' => [
                                                    'optionId' => 4,
                                                    'groupName' => 'Test Group',
                                                    'groupDescription' => 'Test Description',
                                                    'minSelect' => 1,
                                                    'maxSelect' => 1,
                                                    'isRequired' => 0,
                                                    'isActive' => 1,
                                                    'isDeleted' => 0,
                                                    'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['createdAt'],
                                                    'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['updatedAt'],
                                                    'tenantId' => 1,
                                                    'extras' => [
                                                        [
                                                            'joinId' => 10,
                                                            'extraId' => 8,
                                                            'joinIsActive' => 1,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Test Option 3',
                                                            'extraDescription' => 'Test Description 3',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][0]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][0]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][0]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][0]['updatedAt'],
                                                        ],
                                                        [
                                                            'joinId' => 11,
                                                            'extraId' => 9,
                                                            'joinIsActive' => 1,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Test Option 4',
                                                            'extraDescription' => 'Test Description 4',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][1]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][1]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][1]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][1]['updatedAt'],
                                                        ],
                                                        [
                                                            'joinId' => 8,
                                                            'extraId' => 6,
                                                            'joinIsActive' => 0,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Test Option 1',
                                                            'extraDescription' => 'Test Description 1',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 0,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][2]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][2]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][2]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][2]['updatedAt'],
                                                        ],
                                                        [
                                                            'joinId' => 9,
                                                            'extraId' => 7,
                                                            'joinIsActive' => 0,
                                                            'joinIsDeleted' => 1,
                                                            'extraName' => 'Test Option 2',
                                                            'extraDescription' => 'Test Description 2',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 1,
                                                            'isActive' => 0,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][3]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][3]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][3]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][2]['optionGroup']['extras'][3]['updatedAt'],
                                                        ]
                                                    ]
                                                ]
                                            ],
                                            [
                                                'linkId' => 8,
                                                'groupId' => 5,
                                                'isActive' => 1,
                                                'itemId' => 3,
                                                'isDeleted' => 0,
                                                'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['createdAt'],
                                                'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['updatedAt'],
                                                'optionGroup' => [
                                                    'optionId' => 5,
                                                    'groupName' => 'Test Group',
                                                    'groupDescription' => 'Test Description',
                                                    'minSelect' => 1,
                                                    'maxSelect' => 1,
                                                    'isRequired' => 0,
                                                    'isActive' => 1,
                                                    'isDeleted' => 0,
                                                    'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['createdAt'],
                                                    'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['updatedAt'],
                                                    'tenantId' => 1,
                                                    'extras'     =>[
                                                        [
                                                            'joinId' => 14,
                                                            'extraId' => 8,
                                                            'joinIsActive' => 1,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Test Option 3',
                                                            'extraDescription' => 'Test Description 3',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][0]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][0]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][0]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][0]['updatedAt'],
                                                        ],
                                                        [
                                                            'joinId' => 15,
                                                            'extraId' => 9,
                                                            'joinIsActive' => 1,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Test Option 4',
                                                            'extraDescription' => 'Test Description 4',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][1]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][1]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][1]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][1]['updatedAt'],
                                                        ],
                                                        [
                                                            'joinId' => 12,
                                                            'extraId' => 6,
                                                            'joinIsActive' => 0,
                                                            'joinIsDeleted' => 0,
                                                            'extraName' => 'Test Option 1',
                                                            'extraDescription' => 'Test Description 1',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 0,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][2]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][2]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][2]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][2]['updatedAt'],
                                                        ],
                                                        [
                                                            'joinId' => 13,
                                                            'extraId' => 7,
                                                            'joinIsActive' => 0,
                                                            'joinIsDeleted' => 1,
                                                            'extraName' => 'Test Option 2',
                                                            'extraDescription' => 'Test Description 2',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 1,
                                                            'isActive' => 0,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][3]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][3]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][3]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][3]['optionGroup']['extras'][3]['updatedAt'],
                                                        ]
                                                    ]
                                                ]
                                            ],
                                            [
                                                'linkId' => 9,
                                                'groupId' => 1,
                                                'isActive' => 0,
                                                'itemId' => 3,
                                                'isDeleted' => 1,
                                                'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['createdAt'],
                                                'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['updatedAt'],
                                                'optionGroup' => [
                                                    'optionId' => 1,
                                                    'groupName' => 'Updated Group Name',
                                                    'groupDescription' => 'Updated Description',
                                                    'minSelect' => 2,
                                                    'maxSelect' => 4,
                                                    'isRequired' => 0,
                                                    'isActive' => 0,
                                                    'isDeleted' => 1,
                                                    'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['createdAt'],
                                                    'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['updatedAt'],
                                                    'tenantId' => 1,
                                                    'extras' => [
                                                        [
                                                            'joinId' => 1,
                                                            'extraId' => 1,
                                                            'joinIsActive' => 0,
                                                            'joinIsDeleted' => 1,
                                                            'extraName' => 'Updated Option Name',
                                                            'extraDescription' => 'Updated Description',
                                                            'priceAdjustment' => 3.99,
                                                            'isDefault' => 0,
                                                            'isDeleted' => 1,
                                                            'isActive' => 0,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][0]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][0]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][0]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][0]['updatedAt'],
                                                        ],
                                                        [
                                                            'joinId' => 2,
                                                            'extraId' => 2,
                                                            'joinIsActive' => 0,
                                                            'joinIsDeleted' => 1,
                                                            'extraName' => 'Option a1',
                                                            'extraDescription' => 'Description a1',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 1,
                                                            'isActive' => 0,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][1]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][1]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][1]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][1]['updatedAt'],
                                                        ],
                                                        [
                                                            'joinId' => 7,
                                                            'extraId' => 2,
                                                            'joinIsActive' => 0,
                                                            'joinIsDeleted' => 1,
                                                            'extraName' => 'Option a1',
                                                            'extraDescription' => 'Description a1',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 1,
                                                            'isActive' => 0,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][2]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][2]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][2]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][2]['updatedAt'],
                                                        ],
                                                        [
                                                            'joinId' => 3,
                                                            'extraId' => 3,
                                                            'joinIsActive' => 0,
                                                            'joinIsDeleted' => 1,
                                                            'extraName' => 'Option a2',
                                                            'extraDescription' => 'Description a2',
                                                            'priceAdjustment' => 1.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 1,
                                                            'isActive' => 0,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][3]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][3]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][3]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][4]['optionGroup']['extras'][3]['updatedAt'],
                                                        ]
                                                    ]
                                                ]
                                            ],
                                            [
                                                'linkId' => 10,
                                                'groupId' => 6,
                                                'isActive' => 0,
                                                'itemId' => 3,
                                                'isDeleted' => 1,
                                                'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][5]['createdAt'],
                                                'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][5]['updatedAt'],
                                                'optionGroup' => [
                                                    'optionId' => 6,
                                                    'groupName' => 'Test Group 4',
                                                    'groupDescription' => 'Test Description',
                                                    'minSelect' => 1,
                                                    'maxSelect' => 1,
                                                    'isRequired' => 0,
                                                    'isActive' => 0,
                                                    'isDeleted' => 1,
                                                    'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][5]['optionGroup']['createdAt'],
                                                    'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][5]['optionGroup']['updatedAt'],
                                                    'tenantId' => 1,
                                                    'extras' => [
                                                        [
                                                            'joinId' => 16,
                                                            'extraId' => 8,
                                                            'joinIsActive' => 0,
                                                            'joinIsDeleted' => 1,
                                                            'extraName' => 'Test Option 3',
                                                            'extraDescription' => 'Test Description 3',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][5]['optionGroup']['extras'][0]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][5]['optionGroup']['extras'][0]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][5]['optionGroup']['extras'][0]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][5]['optionGroup']['extras'][0]['updatedAt'],
                                                        ],
                                                        [
                                                            'joinId' => 17,
                                                            'extraId' => 9,
                                                            'joinIsActive' => 0,
                                                            'joinIsDeleted' => 1,
                                                            'extraName' => 'Test Option 4',
                                                            'extraDescription' => 'Test Description 4',
                                                            'priceAdjustment' => 0.99,
                                                            'isDefault' => 1,
                                                            'isDeleted' => 0,
                                                            'isActive' => 1,
                                                            'joinCreatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][5]['optionGroup']['extras'][1]['joinCreatedAt'],
                                                            'joinUpdatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][5]['optionGroup']['extras'][1]['joinUpdatedAt'],
                                                            'createdAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][5]['optionGroup']['extras'][1]['createdAt'],
                                                            'updatedAt'     => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['options'][5]['optionGroup']['extras'][1]['updatedAt'],
                                                        ]
                                                    ]
                                                ]
                                            ]
                                        ]
                                    ],
                                    [
                                        'itemId' => 2,
                                        'itemName' => 'Chicken burger',
                                        'itemDescription' => 'Juicy chicken burger with lettuce and tomato',
                                        'basePrice' => 9.99,
                                        'nutritionId' => null,
                                        'isActive' => 1,
                                        'isDeleted' => 0,
                                        'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][1]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][1]['updatedAt'],
                                        'categoryItemId' => 4,
                                        'categoryItemIsActive' => 0,
                                        'categoryItemIsDeleted' => 0,
                                        'tenantId' => 1
                                    ],
                                                                        [
                                        'itemId' => 2,
                                        'itemName' => 'Chicken burger',
                                        'itemDescription' => 'Juicy chicken burger with lettuce and tomato',
                                        'basePrice' => 9.99,
                                        'nutritionId' => null,
                                        'isActive' => 1,
                                        'isDeleted' => 0,
                                        'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][2]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][2]['updatedAt'],
                                        'categoryItemId' => 3,
                                        'categoryItemIsActive' => 0,
                                        'categoryItemIsDeleted' => 1,
                                        'tenantId' => 1
                                ],
                                    [
                                        'itemId' => 1,
                                        'itemName' => 'Cheeseburger',
                                        'itemDescription' => 'Description',
                                        'isActive' => 0,
                                        'basePrice' => 10.99,
                                        'nutritionId' => null,
                                        'isDeleted' => 1,
                                        'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['items'][0]['updatedAt'],
                                        'categoryItemId' => 1,
                                        'categoryItemIsActive' => 1,
                                        'categoryItemIsDeleted' => 1,
                                        'tenantId' => 1,
                                    ]
                                ],
                                'subCategories' => [
                                    [
                                        'categoryId' => 2,
                                        'menuId' => 4,
                                        'categoryName' => 'Classic Bergers',
                                        'categoryDescription' => 'Test Description',
                                        'isActive' => 1,
                                        'isDeleted' => 0,
                                        'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['subCategories'][0]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['subCategories'][0]['updatedAt'],
                                        'parentId' => 1,
                                        
                                    ],
                                    [
                                        'categoryId' => 3,
                                        'menuId' => 4,
                                        'categoryName' => 'Classic Bergers',
                                        'categoryDescription' => 'Test Description',
                                        'isActive' => 1,
                                        'isDeleted' => 0,
                                        'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['subCategories'][1]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['subCategories'][1]['updatedAt'],
                                        'parentId' => 1,
                                        
                                    ],
                                    [
                                        'categoryId' => 4,
                                        'menuId' => 4,
                                        'parentId' => 1,
                                        'categoryName' => 'Dirty Bergers',
                                        'categoryDescription' => 'Test Description',
                                        'isActive' => 0,
                                        'isDeleted' => 1,
                                        'createdAt' => $decodedOutput['menuMenus'][1]['categories'][0]['subCategories'][2]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][1]['categories'][0]['subCategories'][2]['updatedAt'],
                                        
                                    ]
                                ]
                            ]
                        ]
                    ],
                    [
                        'menuId' => 5,
                        'tenantId' => 1,
                        'menuName' => 'Breakfast',
                        'menuDescription' => 'Breakfast Menu',
                        'isActive' => 0,
                        'isDeleted' => 1,
                        'createdAt' => $decodedOutput['menuMenus'][2]['createdAt'],
                        'updatedAt' => $decodedOutput['menuMenus'][2]['updatedAt'],
                        'categories' => [
                            [
                                'categoryId' => 5,
                                'menuId' => 5,
                                'parentId' => null,
                                'categoryName' => 'Pancakes',
                                'categoryDescription' => 'Pancakes Category',
                                'isDeleted' => 1,
                                'isActive' => 1,
                                'createdAt' => $decodedOutput['menuMenus'][2]['categories'][0]['createdAt'],
                                'updatedAt' => $decodedOutput['menuMenus'][2]['categories'][0]['updatedAt'],
                                'subCategories' => [
                                    [
                                        'categoryId' => 6,
                                        'menuId' => 5,
                                        'parentId' => 5,
                                        'categoryName' => 'Fruit Pancakes',
                                        'categoryDescription' => null,
                                        'isActive' => 1,
                                        'isDeleted' => 1,
                                        'createdAt' => $decodedOutput['menuMenus'][2]['categories'][0]['subCategories'][0]['createdAt'],
                                        'updatedAt' => $decodedOutput['menuMenus'][2]['categories'][0]['subCategories'][0]['updatedAt'],
                                        
                                    ]
                                ]
                            ]
                        ]
                    ],
                    [
                        'menuId' => 2,
                        'tenantId' => 1,
                        'menuName' => 'Updated Menu',
                        'menuDescription' => 'Updated Description',
                        'isActive' => 0,
                        'isDeleted' => 1,
                        'createdAt' => $decodedOutput['menuMenus'][3]['createdAt'],
                        'updatedAt' => $decodedOutput['menuMenus'][3]['updatedAt'],
                        'categories' => []
                    ],
                    [
                        'menuId' => 1,
                        'tenantId' => 1,
                        'menuName' => 'Test Menu',
                        'menuDescription' => 'Test Description',
                        'isActive' => 0,
                        'isDeleted' => 1,
                        'createdAt' => $decodedOutput['menuMenus'][4]['createdAt'],
                        'updatedAt' => $decodedOutput['menuMenus'][4]['updatedAt'],
                        'categories' => []
                    ]

                ],
                'security' => [
                    'security' => '1'
                ],
                'action' => 'viewSuperAdminMenus',
            ];
            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals($expectedResult, $decodedOutput);
        } 
        /*
            Need to fix the category Item As this is will not be disabled when the item is disabled
        */
    }

?>