/* ============================================
   1. Add tenant_id to menu_items
   ============================================ */

ALTER TABLE menu_items
    ADD COLUMN tenant_id INTEGER NULL AFTER id;


/* ==========================================================
   2. Backfill menu_items.tenant_id from existing relationships
      (category_items → categories → menus)
   ========================================================== */

UPDATE menu_items i
JOIN menu_category_items ci ON ci.item_id = i.id
JOIN menu_categories c ON c.id = ci.category_id
JOIN menu_menus m ON m.id = c.menu_id
SET i.tenant_id = m.tenant_id
WHERE i.tenant_id IS NULL;

/* NOTE:
   If any items are not assigned to a category,
   tenant_id will still be NULL.
   You can manually set those before enforcing NOT NULL.
*/


/* ============================================
   3. Add tenant_id to menu_option_groups
   ============================================ */

ALTER TABLE menu_option_groups
    ADD COLUMN tenant_id INTEGER NULL AFTER id;


/* ==========================================================
   4. Create new item ↔ option group join table (if needed)
   ========================================================== */

CREATE TABLE IF NOT EXISTS menu_item_to_options (
    id                  INTEGER PRIMARY KEY AUTO_INCREMENT,
    group_id            INTEGER NOT NULL,
    item_id             INTEGER NOT NULL,
    is_active           INTEGER DEFAULT 0,
    is_deleted          INTEGER DEFAULT 0,
    created_at          DATETIME DEFAULT CURRENT_TIMESTAMP,
    updated_at          DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (group_id) REFERENCES menu_option_groups(id),
    FOREIGN KEY (item_id) REFERENCES menu_items(id)
)ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;


/* =====================================================
   5. Migrate old menu_option_groups.item_id values
      into the new join table
   ===================================================== */

INSERT INTO menu_item_to_options (
    group_id,
    item_id,
    is_active,
    is_deleted,
    created_at,
    updated_at
)
SELECT
    id       AS group_id,
    item_id,
    is_active,
    is_deleted,
    created_at,
    updated_at
FROM menu_option_groups;


/* =====================================================
   6. Backfill tenant_id in menu_option_groups (via items)
   ===================================================== */

UPDATE menu_option_groups g
JOIN menu_items i ON g.item_id = i.id
SET g.tenant_id = i.tenant_id
WHERE g.tenant_id IS NULL;


/* =====================================================
   7. Drop FK + drop item_id from menu_option_groups
   ===================================================== */

/* ⚠ IMPORTANT:
   Replace "menu_option_groups_ibfk_1" with whatever name
   your DB actually uses.

   You can find it by running:
       SHOW CREATE TABLE menu_option_groups\G
*/

ALTER TABLE menu_option_groups
    DROP FOREIGN KEY menu_option_groups_ibfk_1;

ALTER TABLE menu_option_groups
    DROP COLUMN item_id;


/* ============================================
   8. Enforce NOT NULL on tenant_id (if desired)
   ============================================ */

ALTER TABLE menu_items
    MODIFY tenant_id INTEGER NOT NULL;

ALTER TABLE menu_option_groups
    MODIFY tenant_id INTEGER NOT NULL;
