-- SQLite-compatible schema with foodBooking_ prefix for table names

-- Enable FK enforcement
PRAGMA foreign_keys = ON;

-- 1. Events
CREATE TABLE foodBooking_events (
  event_id           TEXT    PRIMARY KEY DEFAULT (lower(hex(randomblob(16)))),
  title              TEXT    NOT NULL,
  event_date         TEXT    NOT NULL,             -- ISO date: YYYY-MM-DD
  registration_close TEXT    NOT NULL,
  registration_code  TEXT    NOT NULL UNIQUE,
  created_at         DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CHECK (registration_close < event_date)
);

-- 2. Menu items
CREATE TABLE foodBooking_menu_items (
  menu_item_id TEXT    PRIMARY KEY DEFAULT (lower(hex(randomblob(16)))),
  event_id     TEXT    NOT NULL,
  course       TEXT    NOT NULL CHECK(course IN ('Starter','Main','Dessert')),
  description  TEXT    NOT NULL,
  FOREIGN KEY (event_id) REFERENCES foodBooking_events(event_id) ON DELETE CASCADE
);

-- 3. Users
CREATE TABLE foodBooking_users (
  user_id    TEXT    PRIMARY KEY DEFAULT (lower(hex(randomblob(16)))),
  name       TEXT    NOT NULL,
  mobile     TEXT,
  email      TEXT,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
);

-- 4. Bookings
CREATE TABLE foodBooking_bookings (
  booking_id        TEXT     PRIMARY KEY DEFAULT (lower(hex(randomblob(16)))),
  event_id          TEXT     NOT NULL,
  lead_user_id      TEXT     NOT NULL,
  registration_code TEXT     NOT NULL,
  booked_at         DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UNIQUE(event_id, lead_user_id),
  FOREIGN KEY (event_id)          REFERENCES foodBooking_events(event_id),
  FOREIGN KEY (lead_user_id)      REFERENCES foodBooking_users(user_id),
  FOREIGN KEY (registration_code) REFERENCES foodBooking_events(registration_code) ON UPDATE CASCADE
);

-- 5. Attendees
CREATE TABLE foodBooking_attendees (
  attendee_id          TEXT    PRIMARY KEY DEFAULT (lower(hex(randomblob(16)))),
  booking_id           TEXT    NOT NULL,
  user_id              TEXT    NOT NULL,
  menu_item_id         TEXT    NOT NULL,
  dietary_requirements TEXT    NULL,
  FOREIGN KEY (booking_id)   REFERENCES foodBooking_bookings(booking_id) ON DELETE CASCADE,
  FOREIGN KEY (user_id)      REFERENCES foodBooking_users(user_id),
  FOREIGN KEY (menu_item_id) REFERENCES foodBooking_menu_items(menu_item_id)
);
