# Orbit Core Unit Testing Framework
# ==================================

Write-Host "🧪 Orbit Core Unit Test Framework" -ForegroundColor Cyan
Write-Host "===================================" -ForegroundColor Cyan

# Get project root and set location
$projectRoot = Split-Path -Path $PSScriptRoot -Parent | Split-Path -Parent
Set-Location $projectRoot

Write-Host "Project Root: $projectRoot" -ForegroundColor DarkGray

# Check if composer test configuration exists
if (-not (Test-Path 'composer.test.json')) {
    Write-Host '❌ composer.test.json not found. Please create this file first.'
    exit 1
}

Write-Host "✅ Found composer.test.json" -ForegroundColor Green

# Just run the original test for now to verify it works
if (Test-Path '.\runTest.ps1') {
    Write-Host "📋 Running existing test script..." -ForegroundColor Yellow
    .\runTest.ps1
} else {
    Write-Host "❌ Original runTest.ps1 not found" -ForegroundColor Red
}

Write-Host "✅ Core unit test framework execution completed" -ForegroundColor Green