<?php
namespace Stripe;

class Stripe {
    /** @var string|null The currently set API key */
    protected static ?string $apiKey = null;

    /** @var string|null The currently set Account ID (for Connect) */
    protected static ?string $accountId = null;

    public static function setApiKey(string $key): void {
        self::$apiKey = $key;
    }

    public static function getApiKey(): ?string {
        return self::$apiKey;
    }

    public static function setAccountId(string $id): void {
        self::$accountId = $id;
    }

    public static function getAccountId(): ?string {
        return self::$accountId;
    }
}
