
# Project README

This repository contains several key files that are essential for the operation and configuration of a PHP application. The files should be placed in the root of your PHP directory as specified.

---

## Files Overview

- **`db.php`**: Manages the database connections and executes SQL queries.
- **`Fcors.php`**: Handles Cross-Origin Resource Sharing (CORS) settings, allowing the application to handle requests from different origins securely.
- **`generic.php`**: Processes various types of HTTP requests (GET, POST, and raw JSON) and manages session information.
- **`config.php`** (Template File): Stores configuration settings for the application, including database connection details and global variables.

---

## Detailed File Descriptions

### `db.php`

**Purpose:**  
Manages database connections and executes SQL queries.

**Key Sections:**

- **Database Connection:**  
  - Establishes a connection using credentials (host, username, password, database name).
  - Handles connection errors with appropriate logging.
  
- **Executing Queries:**  
  - Provides functions for various SQL operations (SELECT, INSERT, UPDATE, DELETE).
  - Sanitizes input to prevent SQL injection.

- **Fetching Results:**  
  - Formats query results as associative arrays.
  - Logs any errors encountered while fetching results.

- **Transaction Management:**  
  - Supports database transactions (begin, commit, rollback).
  - Ensures data integrity during operations.

- **Error Handling:**  
  - Implements comprehensive error handling with meaningful debug messages.
  - Logs database operation errors for troubleshooting.

### `Fcors.php`

**Purpose:**  
Handles Cross-Origin Resource Sharing (CORS) settings for the application.

**Key Sections:**

- **Initialization:**  
  - Sets default CORS settings, including allowed origins, methods, and headers.

- **Handling Preflight Requests:**  
  - Manages `OPTIONS` method for preflight requests, ensuring appropriate CORS headers are set.

- **Setting CORS Headers:**  
  - Applies necessary CORS headers for cross-origin requests.

- **Custom CORS Configuration:**  
  - Allows customization of CORS settings based on specific needs.

- **Error Handling:**  
  - Ensures errors related to CORS are logged and managed effectively.

### `generic.php`

**Purpose:**  
Processes HTTP requests (GET, POST, raw JSON) and manages session information.

**Key Sections:**

- **Initialization:**  
  - Sets up initial values like `$URI` and `$inputData` for database connections and session management.
  - Defines actions that require authentication.

- **Session Management:**  
  - Retrieves and manages session timeout and expiration.

- **Processing GET Requests:**  
  - Sanitizes and merges GET parameters into `$inputData`.

- **Processing POST Requests:**  
  - Sanitizes and merges POST parameters into `$inputData`.

- **Handling Raw JSON Input:**  
  - Decodes and sanitizes raw JSON input if no GET or POST parameters are found.

- **Action Handling:**  
  - Checks and assigns actions from `$inputData`.

- **User Session:**  
  - Adds user ID to `$inputData` if a session ID is present.

### `config.php`

**Purpose:**  
Stores configuration settings, including database connections and global variables.

**Key Sections:**

- **Database Connection Information:**  
  - `$host`: MySQL database server hostname.
  - `$user`: Username for MySQL database connection.
  - `$pass`: Password for MySQL database connection.
  - `$sche`: Database/schema name.
  - `$scheGen`: Alternative database/schema name.

- **Global Variable for Debugging:**  
  - `$debugValue`: Static value used for debugging.

- **CORS Potential Fix:**  
  - `$serverAuthUsr`: Username for folder lock authentication.
  - `$serverAuthPas`: Password for folder lock authentication.

---

This documentation should help you understand the purpose and functionality of each file in the project. Ensure these files are placed correctly in the root of your PHP directory for the application to function as expected.

---
