<?php
namespace Stripe;

class Refund {
    /** Unique identifier for the Refund (e.g., "re_1234...") */
    public string $id;

    /** Status of the refund (e.g., 'succeeded', 'failed', 'pending') */
    public string $status;

    /** The ID of the charge that was refunded (e.g., "ch_1234...") */
    public string $charge;

    /** Amount refunded in cents */
    public int $amount;

    public static function create(array $params = []): self {
        return new self();
    }

    public static function retrieve(string $id, array $opts = []): self {
        return new self();
    }
}
