<?php
namespace Stripe;

class PaymentIntent {
    /** Unique identifier for the PaymentIntent (e.g., "pi_1234...") */
    public string $id;

    /** Client secret for frontend confirmation */
    public string $client_secret;

    /** Current status of the PaymentIntent (e.g., 'requires_payment_method', 'succeeded') */
    public string $status;

    /** The ID of the most recent Charge for this PaymentIntent (e.g., "ch_1234...") */
    public ?string $latest_charge = null;

    public static function create(array $params = []): self { return new self(); }

    public static function retrieve(string $id, array $opts = []): self { return new self(); }

    public function confirm(array $params = []): self { return $this; }

    public function cancel(array $params = []): self { return $this; }

    /** Capture funds for this PaymentIntent */
    public function capture(array $params = []): self { return $this; }
}
