<?php
namespace Stripe;

class Charge {
    /** Unique identifier for the Charge (e.g., "ch_1234...") */
    public string $id;

    /** Current status of the Charge (e.g., 'succeeded', 'pending', 'failed') */
    public string $status;

    public static function create(array $params = []): self { return new self(); }

    public static function retrieve(string $id, array $opts = []): self { return new self(); }

    /** Capture funds for this Charge */
    public function capture(array $params = []): self { return $this; }
}
