
CREATE TABLE cms_content_pages (
    id              INT AUTO_INCREMENT PRIMARY KEY,
    page_id         INT NOT NULL,
    tagname         VARCHAR(50) NOT NULL,
    content         MEDIUMTEXT,  -- MEDIUMTEXT can store up to 16MB, which should be adequate for large text
    created_date    DATETIME DEFAULT CURRENT_TIMESTAMP,
    modified_date   DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    is_deleted      TINYINT(1) DEFAULT 0,  -- A simple flag to mark the row as deleted
    deleted_date    DATETIME DEFAULT NULL,  -- Timestamp for when the page was marked as deleted
    deprecated_date DATETIME DEFAULT NULL,  -- Timestamp for when the page was marked as deprecated
    UNIQUE (page_id, tagname)  -- Ensures the combination of page_id and tagname is unique
);


CREATE TABLE cms_content_changes (
    change_id           INT AUTO_INCREMENT PRIMARY KEY,
    page_id             INT NOT NULL,
    tagname             VARCHAR(20) NOT NULL,
    previous_content    MEDIUMTEXT,
    changed_at          DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (page_id) REFERENCES cms_content_pages(page_id)
);
Go;


CREATE TRIGGER cms_content_pages_update_modified_date
BEFORE UPDATE ON cms_content_pages
FOR EACH ROW
BEGIN
    SET NEW.modified_date = NOW();
END $$

--  Set the delimiter in sql to "$$" othewerwise we will get failure

