<?php

namespace Azui\Orbit\CMSImage;

// this should only be used for testing purposes
if (defined('TEST_ENV')) {
    //require_once __DIR__ . '/../../orbit-core/src/config.php';
    // Flexible path resolution for core files
    if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "src" . DIRECTORY_SEPARATOR . "Fcors.php")) {
        require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "src" . DIRECTORY_SEPARATOR . "Fcors.php";
    } else {
        require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "Fcors.php";
    }
    // Flexible path resolution for core files
    if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "unit-test" . DIRECTORY_SEPARATOR . "scripts" . DIRECTORY_SEPARATOR . "bootstrap.php")) {
        require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "unit-test" . DIRECTORY_SEPARATOR . "scripts" . DIRECTORY_SEPARATOR . "bootstrap.php";
    } else {
        require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "unit-test" . DIRECTORY_SEPARATOR . "scripts" . DIRECTORY_SEPARATOR . "bootstrap.php";
    }
    // Flexible path resolution for core files
    if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "src" . DIRECTORY_SEPARATOR . "generic.php")) {
        require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "src" . DIRECTORY_SEPARATOR . "generic.php";
    } else {
        require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "generic.php";
    }
    $testInfo['0'] = ("\nFunction Running in Test Environment\n");
} else {
    // this is code for live environment Dev, Uat, Production
    require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "error_monitor.php";
    require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "generic.php";
}

require_once __DIR__ . DIRECTORY_SEPARATOR . "core.php";
require_once __DIR__ . DIRECTORY_SEPARATOR . "view.php";
require_once __DIR__ . DIRECTORY_SEPARATOR . "insert.php";
require_once __DIR__ . DIRECTORY_SEPARATOR . "update.php";

$inputData =\initializeGeneric();

$inputData['requiresAdmin'] = ['CMSImageUpdate','CMSImageInsert','CMSTagNames','CMSImageDelete','CMSNewImageTag','CMSImageTagDisable','CMSNewImageMapping','CMSImageMappingDisable'];
$inputData['keepLive'] = \checkLive();

if(!isset($inputData['action']) || empty($inputData['action'])){
    $out['status']   = 'failed';
    $out['message']  = 'No Action Found';
    echo json_encode(\propagateStatusAndMessage($out));
exit;
}

$action = $inputData['action'];

// check if action need auth and if does check it valid otherwise move to swithc statments 
$security = \SecurityCheck($inputData); // skip security for a bit 

if($security['security'] === '1'){
    switch ($action) {
        case "CMSImageUpdate":
            // need id            
            if((!isset($inputData['pageId'])) || (!isset($inputData['imageTitle'])) || (!isset($inputData['imageName'])) || (!isset($inputData['imagePath'])) || (!isset($inputData['imageId']))){
                $out['result']['status']   = 'failed';
                $out['result']['message']  = 'Missing required fields';
                break;
            }else{
                $out = updatePageContentWithLogging($inputData);
                break;
            }
        case "CMSImageInsert":
            $inputData['nextOperation']      = __NAMESPACE__ . '\insertNewItem';
            $out = executeDatabaseOperation($inputData);
            break;
        case "CMSImageContent":
            $inputData['nextOperation']      = __NAMESPACE__ . '\selectCurrentContent';
            $out = executeDatabaseOperation($inputData);
            break;
        case "CMSTagNames":
            $out = getTagList($inputData);
            break;
        case "CMSImageDelete":
            if(!isset($inputData['imageId'])){
                $out['result']['status']   = 'failed';
                $out['result']['message']  = 'Missing required fields';
                break;
            }
            $inputData['nextOperation']      = __NAMESPACE__ . '\softDeleteContent';
            $out = executeDatabaseOperation($inputData);
            break;
        case "CMSNewImageTag":
            if(!isset($inputData['tagName'])){
                $out['result']['status']   = 'failed';
                $out['result']['message']  = 'Missing required fields';
                break;
            }
            $out = newTag($inputData);
            break;
        case "CMSImageTagDisable":
            if(!isset($inputData['tagId'])){
                $out['result']['status']   = 'failed';
                $out['result']['message']  = 'Missing required fields';
                break;
            }
            $inputData['mappingValue']  = 'tag_id';
            $inputData['tableName']     = 'cms_image_tag';
            $inputData['id']            = $inputData['tagId'];
            $out = disableRow($inputData);
            break;
        case "CMSNewImageMapping":
            if(!isset($inputData['imageId']) || !isset($inputData['tagId'])){
                $out['result']['status']   = 'failed';
                $out['result']['message']  = 'Missing required fields';
                break;
            }
            $out = newMapping($inputData);
            break;
        case "CMSImageMappingDisable":
            if(!isset($inputData['mapId'])){
                $out['result']['status']   = 'failed';
                $out['result']['message']  = 'Missing required fields';
                break;
            }
            $inputData['mappingValue']  = 'map_id';
            $inputData['tableName']     = 'cms_image_tag_map';
            $inputData['id']            = $inputData['mapId'];
            $out = disableRow($inputData);
            break;
        default:
            $out['result']['status']   = 'failed';
            $out['result']['message']  = 'No Action Found';
            break;
    }
}else{
    $out = $security;
    if($security['security'] === '0'){
        unset($out['security']);
    }

}

if(defined('TEST_ENV')){
//    $out['testInfo']['1'] = $testInfo;
//    $out['testInfo']['2'] = $_GET;
//    $out['testInfo']['3'] = $_POST;
//    $out['inputData'] = $inputData;
      $out['security'] = $security;
      $out['action'] = $action;
}

\cleanUpOutputData($out);
echo json_encode(\propagateStatusAndMessage($out));
?>
