<?php
// this should only be used for testing purposes
if (defined('TEST_ENV')) {
    //require_once __DIR__ . '/../../orbit-core/src/config.php';
    require_once __DIR__ . '\..\..\core\src\Fcors.php';
    require_once __DIR__ . '\..\..\tests\scripts\bootstrap.php';
    require_once __DIR__ . '\..\..\core\src\generic.php';
    $testInfo['0'] = ("\nFunction Running in Test Environment\n");
} else {
    // this is code for live environment Dev, Uat, Production
    require_once __DIR__ . "./../config.php";
    require_once __DIR__ . "./../Fcors.php";
    require_once __DIR__ . "./../db.php";
    require_once __DIR__ . "./../generic.php";
}

require_once __DIR__ . "/core.php";
require_once __DIR__ . "/view.php";
require_once __DIR__ . "/insert.php";
require_once __DIR__ . "/update.php";

$inputData = initializeGeneric();

$inputData['requiresAdmin'] = ['CMSImageUpdate','CMSImageInsert','CMSTagNames','CMSImageDelete','CMSNewImageTag','CMSImageTagDisable','CMSNewImageMapping','CMSImageMappingDisable'];
$inputData['keepLive'] = checkLive();
$action = $inputData['action'];

// check if action need auth and if does check it valid otherwise move to swithc statments 
$security = SecurityCheck($inputData); // skip security for a bit 

if($security['security'] === '1'){
    switch ($action) {
        case "CMSImageUpdate":
            $out = updatePageContentWithLogging($inputData);
            break;
        case "CMSImageInsert":
            $inputData['nextOperation'] = 'insertNewItem';
            $out = executeDatabaseOperation($inputData);
            break;
        case "CMSImageContent":
            $inputData['nextOperation'] = 'selectCurrentContent';
            $out = executeDatabaseOperation($inputData);
            break;
        case "CMSTagNames":
            $out = getTagList($inputData);
            break;
        case "CMSImageDelete":
            $inputData['nextOperation'] = 'softDeleteContent';
            $out = executeDatabaseOperation($inputData);
            break;
        case "CMSNewImageTag":
            $out = newTag($inputData);
            break;
        case "CMSImageTagDisable":
            $inputData['mappingValue']  = 'tag_id';
            $inputData['tableName']     = 'cms_image_tag';
            $out = disableRow($inputData);
            break;
        case "CMSNewImageMapping":
            $out = newMapping($inputData);
            break;
        case "CMSImageMappingDisable":
            $inputData['mappingValue']  = 'map_id';
            $inputData['tableName']     = 'cms_image_tag_map';
            $out = disableRow($inputData);
            break;
        default:
            $out['result']['status']   = 'failed';
            $out['result']['message']  = 'No Action Found';
            break;
    }
}else{
    $out = $security;
    if($security['security'] === '0'){
        unset($out['security']);
    }

}

if(defined('TEST_ENV')){
//    $out['testInfo']['1'] = $testInfo;
//    $out['testInfo']['2'] = $_GET;
//    $out['testInfo']['3'] = $_POST;
//    $out['inputData'] = $inputData;
      $out['security'] = $security;
      $out['action'] = $action;
}

echo json_encode($out);
?>
