CREATE TABLE cms_image (
    id              INTEGER PRIMARY KEY AUTOINCREMENT,
    parent_id       INT NULL default 0,  -- A reference to the parent image, if applicable
    page_id         INT NOT NULL,
    image_title     VARCHAR(50) NOT NULL,
    image_name      VARCHAR(50) NOT NULL,  -- MEDIUMTEXT can store up to 16MB, which should be adequate for large text
    image_path      VARCHAR(100),
    image_alt       VARCHAR(100),
    image_priority  INT NULL,  -- A simple integer to determine the order of images
    created_date    DATETIME DEFAULT CURRENT_TIMESTAMP,
    modified_date   DATETIME DEFAULT CURRENT_TIMESTAMP,
    is_deleted      TINYINT(1) DEFAULT 0,  -- A simple flag to mark the row as deleted
    deleted_date    DATETIME DEFAULT NULL,  -- Timestamp for when the page was marked as deleted
    deprecated_date DATETIME DEFAULT NULL,  -- Timestamp for when the page was marked as deprecated
    UNIQUE (page_id, image_title, image_name)
);


CREATE TABLE cms_image_changes (
    change_id       INTEGER PRIMARY KEY AUTOINCREMENT,
    image_id        INT NOT NULL,
    parent_id       INT NULL default 0,
    page_id         INT NOT NULL,
    image_title     VARCHAR(50) NOT NULL,
    previous_image  VARCHAR(50),
    image_path      VARCHAR(100),
    image_alt       VARCHAR(100),
    image_priority  INT NULL,
    changed_at      DATETIME DEFAULT CURRENT_TIMESTAMP
);


CREATE Table cms_image_tag (
    tag_id          INTEGER PRIMARY KEY AUTOINCREMENT,
    tag_name        VARCHAR(50) NOT NULL,
    created_date    DATETIME DEFAULT CURRENT_TIMESTAMP,
    modified_date   DATETIME DEFAULT CURRENT_TIMESTAMP,
    is_deleted      TINYINT(1) DEFAULT 0,
    deleted_date    DATETIME DEFAULT NULL,
    UNIQUE (tag_name)
);


CREATE TABLE cms_image_tag_changes (
    change_id       INTEGER PRIMARY KEY AUTOINCREMENT,
    tag_id          INT NOT NULL,
    previous_tagname VARCHAR(50),
    changed_at      DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (tag_id) REFERENCES cms_image_tags(tag_id)
);


CREATE TABLE cms_image_tag_map (
    map_id          INTEGER PRIMARY KEY AUTOINCREMENT,
    image_id        INT NOT NULL,
    tag_id          INT NOT NULL,
    created_date    DATETIME DEFAULT CURRENT_TIMESTAMP,
    modified_date   DATETIME DEFAULT CURRENT_TIMESTAMP,
    is_deleted      TINYINT(1) DEFAULT 0,
    deleted_date    DATETIME DEFAULT NULL,
    FOREIGN KEY (image_id) REFERENCES cms_image(id),
    FOREIGN KEY (tag_id) REFERENCES cms_image_tag(tag_id)
);


CREATE TRIGGER IF NOT EXISTS cms_image_update_modified_date
BEFORE UPDATE ON cms_image
FOR EACH ROW
BEGIN
    UPDATE cms_content_pages
    SET modified_date = CURRENT_TIMESTAMP
    WHERE id = old.id;
END;


CREATE TRIGGER IF NOT EXISTS cms_image_tag_update_modified_date
BEFORE UPDATE ON cms_image_tag
FOR EACH ROW
BEGIN
    UPDATE cms_image_tag
    SET modified_date = CURRENT_TIMESTAMP
    WHERE tag_id  = old.tag_id ;
END;


CREATE TRIGGER IF NOT EXISTS cms_image_tag_map_update_modified_date
BEFORE UPDATE ON cms_image_tag_map
FOR EACH ROW
BEGIN
    UPDATE cms_image_tag_map
    SET modified_date = CURRENT_TIMESTAMP
    WHERE map_id = old.map_id;
END;


INSERT INTO `cms_image` ( `parent_id`, `page_id`, `image_title`, `image_name`, `image_path`, `image_alt`, `image_priority`, `created_date`, `modified_date`, `is_deleted`, `deleted_date`, `deprecated_date`) VALUES
(0, 1, 'Media Wall 1 ', 'IMG_0061.jpeg', 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev', 'IMG_0061.jpeg', 0,     '2024-09-24 09:14:31', '2024-10-30 23:00:12', 0, NULL, NULL),
(1, 1, 'Media Wall 1 ', 'IMG_0062.jpeg', 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev', 'IMG_0062.jpeg', 1,     '2024-09-24 09:14:31', '2024-10-30 23:00:12', 0, NULL, NULL),
(1, 1, 'Media Wall 1 ', 'IMG_0063.jpeg', 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev', 'IMG_0063.jpeg', 2,     '2024-09-24 09:14:31', '2024-10-30 23:00:12', 0, NULL, NULL),
(1, 1, 'Media Wall 1 ', 'IMG_0064.jpeg', 'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev', 'IMG_0064.jpeg', 3,     '2024-09-24 09:14:31', '2024-10-30 23:00:12', 0, NULL, NULL),
(0, 1, 'Media Wall 1 ', 'IMG_0222.jpg',  'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev', 'IMG_0222.jpg', NULL,   '2024-09-24 09:14:31', '2024-10-30 23:00:12', 0, NULL, NULL),
(0, 1, 'Media Wall 1 ', 'IMG_0223.jpg',  'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev', 'IMG_0223.jpg', NULL,   '2024-09-24 09:14:31', '2024-10-30 23:00:12', 0, NULL, NULL),
(0, 1, 'Media Wall 1 ', 'IMG_0224.jpg',  'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev', 'IMG_0224.jpg', NULL,   '2024-09-24 09:14:31', '2024-10-30 23:00:12', 0, NULL, NULL),
(0, 2, 'Media Wall 1 ', 'IMG_0226.jpg',  'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev', 'IMG_0226.jpg', NULL,   '2024-09-24 09:14:31', '2024-10-30 23:00:12', 0, NULL, NULL),
(0, 2, 'Media Wall 1 ', 'IMG_0227.jpg',  'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev', 'IMG_0227.jpg', NULL,   '2024-09-24 09:14:31', '2024-10-30 23:00:12', 0, NULL, NULL),
(0, 2, 'Media Wall 1 ', 'IMG_0228.jpg',  'https://stv2bournbespokeimg.blob.core.windows.net/bourne-bespoke-web-img/dev', 'IMG_0228.jpg', NULL,   '2024-09-24 09:14:31', '2024-10-30 23:00:12', 0, NULL, NULL);


INSERT INTO `cms_image_tag` (`tag_name`, `created_date`, `modified_date`, `is_deleted`, `deleted_date`) VALUES
( 'Media Walls',  '2024-08-21 12:34:27', '2024-09-23 09:59:56', 0, NULL),
( 'Drinks Bars',  '2024-08-21 12:37:11', '2024-09-23 09:59:59', 0, NULL),
( 'Offices',      '2024-08-21 12:57:40', '2024-09-23 10:00:01', 0, NULL),
( 'Wardrobes',    '2024-08-21 13:19:38', '2024-09-23 10:00:03', 0, NULL),
( 'Other',        '2024-09-23 10:00:15', '2024-09-23 10:00:15', 0, NULL),
( 'Kitchens',     '2024-09-23 10:00:17', '2024-09-23 10:00:17', 1, NULL);


INSERT INTO `cms_image_tag_map` (`image_id`, `tag_id`, `created_date`, `modified_date`, `is_deleted`, `deleted_date`) VALUES
( 1,      4, '2024-09-23 10:06:36', '2024-09-23 10:06:36', 0, NULL),
( 2,      4, '2024-09-23 10:06:36', '2024-09-23 10:06:36', 0, NULL),
( 3,      4, '2024-09-23 10:06:36', '2024-09-23 10:06:36', 0, NULL),
( 4,      4, '2024-09-23 10:06:36', '2024-09-23 10:06:36', 0, NULL),
( 5,      1, '2024-09-23 10:06:36', '2024-09-23 10:06:36', 0, NULL),
( 6,      1, '2024-09-23 10:06:36', '2024-09-23 10:06:36', 0, NULL),
( 7,      2, '2024-09-23 10:06:36', '2024-09-23 10:06:36', 0, NULL),
( 8,      3, '2024-09-23 10:06:36', '2024-09-23 10:06:36', 0, NULL),
( 9,      1, '2024-09-23 10:06:36', '2024-09-23 10:06:36', 0, NULL),
( 10,     1, '2024-09-23 10:06:36', '2024-09-23 10:06:36', 0, NULL);