<?php

    function updatePageContentWithLogging($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->beginTransaction();
        $result = [];
        try {
            // Select the current content
            $inputData['nextOperation']         ='selectCurrentContent';
            $result['nextOperation'][]          ='selectCurrentContent';
            $inputData['DataForLog']            = 1;
            $data                               = executeDatabaseOperation($inputData);
            if($data['status'] == 'failed'){
                $result['output'] = $data;
                $result['error'] = 'No content found';
                return $result;
            }
            $inputData['getold_parent_id']      = isset($data['cmsCont'][0]['parentId']) ? $data['cmsCont'][0]['parentId'] : 0;
            $inputData['getOld_image_name']     = $data['cmsCont'][0]['imageName'];
            $inputData['getOld_image_path']     = $data['cmsCont'][0]['imagePath'];
            $inputData['getOld_image_alt']      = $data['cmsCont'][0]['imageAlt'];
            $inputData['getOld_image_priority'] = $data['cmsCont'][0]['imagePriority'];
            $inputData['getOld_image_title']    = $data['cmsCont'][0]['imageTitle'];
            $result['output'][]                 = $data;

            if(is_null($inputData['getOld_image_name'])){
                $inputData['nextOperation'] = 'insertNewItem';
                $result['nextOperation'][]  = $inputData['nextOperation'];
                $data                       = executeDatabaseOperation($inputData);
                $result['output'][]         = $data;
            }else{

            // Insert a change log record
            $inputData['nextOperation']     = 'insertChangeRecord';
            $result['nextOperation'][]      = $inputData['nextOperation'];
            $data                           = executeDatabaseOperation($inputData);
            $inputData['insertChangeRecord']= $data;
            $result['output'][]             = $data;
            //insertChangeRecord($inputData);
            
            // Update the page with new content
            $inputData['nextOperation']    ='updateContent';
            $result['nextOperation'][]     = $inputData['nextOperation'];
            $data                          = executeDatabaseOperation($inputData);
            if ($data['status'] == 'failed') {
                $result['status'] = $data['status'];
                $result['message'] = $data['message'];
            }
            $inputData['updateContent']    = $data;
            $result['output'][]            = $data;
            // Commit transaction
            }
        
            $pdo->commit();
        } catch (Exception $e) {
            // Rollback transaction on error
            $pdo->rollback();
            $result['error'] =  $e;
        }
        return $result;
    }
    function updatePageTagWithLogging($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->beginTransaction();
        $result = [];
        try {
            $inputData['nextOperation']         ='getTagList';
            $result['nextOperation'][]          ='getTagList';
            $data                               = executeDatabaseOperation($inputData);
            $inputData['getOld_image_title']        = $data['image_title'];
            $result['output'][]             = $data;

            if(is_null($inputData['getOld_image_title'])){
                $inputData['nextOperation'] = 'insertNewItem';
                $result['nextOperation'][]  = $inputData['nextOperation'];
                $data                       = executeDatabaseOperation($inputData);
                $result['output'][]         = $data;
            }else{
                // Insert a change log record
            $inputData['nextOperation']     = 'insertTagChangeRecord';
            $result['nextOperation'][]      = $inputData['nextOperation'];
            $data                           = executeDatabaseOperation($inputData);
            $inputData['insertChangeRecord']= $data;
            $result['output'][]             = $data;
            //insertChangeRecord($inputData);
            
            // Update the page with new content
            $inputData['nextOperation']    ='updateTag';
            $result['nextOperation'][]     = $inputData['nextOperation'];
            $data                          = executeDatabaseOperation($inputData);
            $inputData['updateContent']    = $data;
            $result['output'][]            = $data;
            // Commit transaction
            }
            $pdo->commit(); 
        } catch (Exception $e) {
            // Rollback transaction on error
            $pdo->rollback();
            $result['error'] =  $e;
        }
        return $result;
    }
    function executeDatabaseOperation( $inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function newTag($inputData){
        $checkResults = checkTagExists($inputData);
        if($checkResults['status'] == 'failed'){
            $result = insertTag($inputData);
            return $result;
        }elseif($checkResults['status'] == 'success' and $checkResults['isDeleted'] == 1){
            $inputData['tableName'] = 'cms_image_tag';
            $inputData['mappingValue'] = 'tag_id';
            $inputData['id'] = $checkResults['tagId'];
            $result = enableRow($inputData);
            return $result;
        }else{
            return ['status' => 'failed', 'message' => 'Tag already exists'];
        }
    }
    function newMapping($inputData){
        $checkResults = checkMappingExists($inputData);
        if($checkResults['status'] == 'failed'){
            $result = insertNewMapping($inputData);
            return $result;
        }elseif($checkResults['status'] == 'success' and $checkResults['isDeleted'] == 1){
            $inputData['tableName'] = 'cms_image_tag_map';
            $inputData['mappingValue'] = 'map_id';
            $inputData['id'] = $checkResults['mapId'];
            $result = enableRow($inputData);
            return $result;
        }else{
            return ['status' => 'failed', 'message' => 'Mapping already exists', 'checkResults' => $checkResults];
        }
    }
?>