<?php
    function insertNewItem($inputData) {
        try {
            $pdo = $inputData['db']['dbApp'];
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            $parentId = $inputData['parentId'] ?? 0;

            if(!isset($inputData['imagePath']) || empty($inputData['imagePath'])){
                return ['status' => 'failed', 'message' => 'Image path is required'];
            }
            if(!isset($inputData['imageName']) || empty($inputData['imageName'])){
                return ['status' => 'failed', 'message' => 'Image name is required'];
            }

            if(!isset($inputData['pageId']) || empty($inputData['pageId'])){
                return ['status' => 'failed', 'message' => 'Page id is required'];
            }

            if(!isset($inputData['imageTitle']) || empty($inputData['imageTitle'])){
                return ['status' => 'failed', 'message' => 'Image title is required'];
            }

            $sql = "INSERT INTO cms_image (parent_id, page_id, image_title, image_name, image_path, image_alt, image_priority) VALUES (:parentId, :pageId, :imageTitle, :imageName, :imagePath, :imageAlt, :imagePriority)";
            $stmt = $pdo->prepare($sql);    
            $stmt->bindParam(':parentId',       $parentId);
            $stmt->bindParam(':pageId',         $inputData['pageId']);
            $stmt->bindParam(':imageTitle',     $inputData['imageTitle']);
            $stmt->bindParam(':imageName',      $inputData['imageName']);
            $stmt->bindParam(':imagePath',      $inputData['imagePath']);
            $stmt->bindParam(':imageAlt',       $inputData['imageAlt']);
            $stmt->bindParam(':imagePriority',  $inputData['imagePriority']);
            $stmt->execute();
            return ['status' => 'success', 'message' => 'Item inserted successfully'];
        } catch (PDOException $e) {
            // Check if debug mode is set to 'CSD'
            if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugMode']) {
                // Output the error message
                echo "Error: " . $e->getMessage();
            }

            // Return the error message
            return ['status' => 'error', 'message' => $e->getMessage()];
        }
    }
    function insertChangeRecord($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $sql = "INSERT INTO cms_image_changes (image_id ,parent_id, page_id, image_title, previous_image, image_path, image_alt, image_priority) VALUES (:image_id, :parentId, :pageId, :imageTitle, :previousImage, :imagePath, :imageAlt, :imagePriority)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':pageId',        $inputData['pageId']);
        $stmt->bindParam(':image_id',      $inputData['imageId']);
        $stmt->bindParam(':parentId',      $inputData['getold_parent_id']);
        $stmt->bindParam(':imageTitle',    $inputData['getOld_image_title']);
        $stmt->bindParam(':previousImage', $inputData['getOld_image_name']);
        $stmt->bindParam(':imagePath',      $inputData['getOld_image_path']);
        $stmt->bindParam(':imageAlt',       $inputData['getOld_image_alt']);
        $stmt->bindParam(':imagePriority', $inputData['getOld_image_priority']);
        $stmt->execute();
        return ['status' => 'success', 'message' => 'Item inserted successfully'];
    }

    function insertTag($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $sql = "INSERT INTO cms_image_tag (tag_name) VALUES (:tagName)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tagName', $inputData['tagName']);
        $stmt->execute();
        return ['status' => 'success', 'message' => 'Tag inserted successfully'];
    }

    function insertTagChangeRecord($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $sql = "INSERT INTO cms_image_tag_changes (tag_id, previous_image_title) VALUES (:tagId, :previousimage_title)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tagId', $inputData['tagId']);
        $stmt->bindParam(':previousimage_title', $inputData['getOld_image_title']);
        $stmt->execute();
        return ['status' => 'success', 'message' => 'Tag change record inserted successfully'];
    }

    function insertNewMapping($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $sql = "INSERT INTO cms_image_tag_map (tag_id, image_id) VALUES (:tagId, :imageId)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tagId', $inputData['tagId']);
        $stmt->bindParam(':imageId', $inputData['imageId']);
        $stmt->execute();
        return ['status' => 'success', 'message' => 'Mapping inserted successfully'];
    }
?>