<?php
    // Review 
    function updateContent($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $parentId = $inputData['getold_parent_id'] ?? 0;
        $sql = "UPDATE cms_image SET parent_id = :parent_id, image_name = :image_name, image_path = :image_path, image_alt = :image_alt, image_priority =:image_priority, image_title = :image_title   WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        // $stmt->bindParam(':pageId',         $inputData['pageId']);
        $stmt->bindParam(':image_title',    $inputData['imageTitle']);
        $stmt->bindParam(':image_name',     $inputData['imageName']);
        $stmt->bindParam(':image_path',     $inputData['imagePath']);
        $stmt->bindParam(':image_alt',      $inputData['imageAlt']);
        $stmt->bindParam(':image_priority', $inputData['imagePriority']);
        $stmt->bindParam(':parent_id',      $parentId);
        $stmt->bindParam(':id',             $inputData['imageId']);
        $stmt->execute();
        return ['status' => 'success', 'message' => 'Item Updated successfully'];
    }

    function updateTag($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $sql = "UPDATE cms_image_tag SET tag_name = :tagName WHERE tag_id = :tagId";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tagName', $inputData['tagName']);
        $stmt->bindParam(':tagId', $inputData['tagId']);
        $stmt->execute();
        return ['status' => 'success', 'message' => 'Tag Updated successfully'];
    }

    function softDeleteContent($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $sql = "UPDATE cms_image SET is_deleted = 1, deleted_date = CURRENT_TIMESTAMP WHERE id = :imageId";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':imageId', $inputData['imageId']);
        $stmt->execute();
        return ['status' => 'success', 'message' => 'Item deleted successfully'];
    }

    function enableRow($inputData) {
        try {
            $pdo = $inputData['db']['dbApp'];
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $sql = "UPDATE ".$inputData['tableName']." SET is_deleted = 0, deleted_date = null WHERE ".$inputData['mappingValue']." = :value";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':value', $inputData['id']);
            $stmt->execute();
            if ($stmt->rowCount() > 0) {
                return ['status' => 'success', 'message' => 'Enabled successfully'];
            } else {
                return ['status' => 'error', 'message' => 'Not found'];
            }
        } catch (PDOException $e) {
            if (isset($inputData['debug']) && $inputData['debug'] === 'CSD') {
                echo "Error: " . $e->getMessage();
            }
            return ['status' => 'error', 'message' => $e->getMessage()];
        }
    }
    function disableRow($inputData) {
        try {
            $pdo = $inputData['db']['dbApp'];
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $sql = "UPDATE ".$inputData['tableName']." SET is_deleted = 1, deleted_date = NOW() WHERE ".$inputData['mappingValue']." = :value";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':value', $inputData['id']);
            $stmt->execute();
            if ($stmt->rowCount() > 0) {
                return ['status' => 'success', 'message' => 'Disabled successfully'];
            } else {
                return ['status' => 'error', 'message' => 'Not found'];
            }
        } catch (PDOException $e) {
            if (isset($inputData['debug']) && $inputData['debug'] === 'CSD') {
                echo "Error: " . $e->getMessage();
            }
            return ['status' => 'error', 'message' => $e->getMessage()];
        }
    }  
?>